/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.mock;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.wicket.Session;
import org.apache.wicket.request.Request;
import org.apache.wicket.session.ISessionStore;

public class MockSessionStore
implements ISessionStore {
    private String sessionId;
    private final Map<String, Serializable> attributes = new HashMap<String, Serializable>();
    private final Set<ISessionStore.UnboundListener> unboundListeners = new CopyOnWriteArraySet<ISessionStore.UnboundListener>();
    private final Set<ISessionStore.BindListener> bindListeners = new CopyOnWriteArraySet<ISessionStore.BindListener>();
    private Session session;

    @Override
    public void bind(Request request, Session newSession) {
        this.session = newSession;
    }

    @Override
    public void destroy() {
        this.cleanup();
    }

    @Override
    public Serializable getAttribute(Request request, String name) {
        return this.attributes.get(name);
    }

    @Override
    public List<String> getAttributeNames(Request request) {
        return Collections.unmodifiableList(new ArrayList<String>(this.attributes.keySet()));
    }

    @Override
    public String getSessionId(Request request, boolean create) {
        if (create && this.sessionId == null) {
            this.sessionId = UUID.randomUUID().toString();
        }
        return this.sessionId;
    }

    private void cleanup() {
        this.sessionId = null;
        this.attributes.clear();
        this.session = null;
    }

    @Override
    public void invalidate(Request request) {
        String sessId = this.sessionId;
        this.cleanup();
        for (ISessionStore.UnboundListener l : this.unboundListeners) {
            l.sessionUnbound(sessId);
        }
    }

    @Override
    public Session lookup(Request request) {
        return this.session;
    }

    @Override
    public void registerUnboundListener(ISessionStore.UnboundListener listener) {
        this.unboundListeners.add(listener);
    }

    @Override
    public void removeAttribute(Request request, String name) {
        this.attributes.remove(name);
    }

    @Override
    public final Set<ISessionStore.UnboundListener> getUnboundListener() {
        return Collections.unmodifiableSet(this.unboundListeners);
    }

    @Override
    public void setAttribute(Request request, String name, Serializable value) {
        this.attributes.put(name, value);
    }

    @Override
    public void unregisterUnboundListener(ISessionStore.UnboundListener listener) {
        this.unboundListeners.remove(listener);
    }

    @Override
    public void registerBindListener(ISessionStore.BindListener listener) {
        this.bindListeners.add(listener);
    }

    @Override
    public void unregisterBindListener(ISessionStore.BindListener listener) {
        this.bindListeners.remove(listener);
    }

    @Override
    public Set<ISessionStore.BindListener> getBindListeners() {
        return Collections.unmodifiableSet(this.bindListeners);
    }

    @Override
    public void flushSession(Request request, Session session) {
        this.session = session;
    }
}

