/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.form;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AjaxFormComponentUpdatingBehavior
extends AjaxEventBehavior {
    private static final Logger log = LoggerFactory.getLogger(AjaxFormComponentUpdatingBehavior.class);
    private static final long serialVersionUID = 1L;

    public AjaxFormComponentUpdatingBehavior(String event) {
        super(event);
    }

    @Override
    protected void onBind() {
        super.onBind();
        Component component = this.getComponent();
        if (!(component instanceof FormComponent)) {
            throw new WicketRuntimeException("Behavior " + this.getClass().getName() + " can only be added to an instance of a FormComponent");
        }
        this.checkComponent((FormComponent)component);
    }

    protected void checkComponent(FormComponent<?> component) {
        if (Application.get().usesDevelopmentConfig() && AjaxFormChoiceComponentUpdatingBehavior.appliesTo(component)) {
            log.warn(String.format("AjaxFormComponentUpdatingBehavior is not supposed to be added in the form component at path: \"%s\". Use the AjaxFormChoiceComponentUpdatingBehavior instead, that is meant for choices/groups that are not one component in the html but many", component.getPageRelativePath()));
        }
    }

    protected final FormComponent<?> getFormComponent() {
        return (FormComponent)this.getComponent();
    }

    @Override
    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        attributes.setMethod(AjaxRequestAttributes.Method.POST);
        attributes.setAllowDefault(true);
    }

    @Override
    protected final void onEvent(AjaxRequestTarget target) {
        FormComponent<?> formComponent = this.getFormComponent();
        if ("blur".equals(this.getEvent().toLowerCase()) && this.disableFocusOnBlur()) {
            target.focusComponent(null);
        }
        try {
            formComponent.inputChanged();
            formComponent.validate();
            if (formComponent.isValid()) {
                formComponent.valid();
                if (this.getUpdateModel()) {
                    formComponent.updateModel();
                }
                this.onUpdate(target);
            } else {
                formComponent.invalid();
                this.onError(target, null);
            }
        }
        catch (RuntimeException e) {
            this.onError(target, e);
        }
    }

    protected boolean getUpdateModel() {
        return true;
    }

    protected boolean disableFocusOnBlur() {
        return true;
    }

    protected abstract void onUpdate(AjaxRequestTarget var1);

    protected void onError(AjaxRequestTarget target, RuntimeException e) {
        if (e != null) {
            throw e;
        }
    }
}

