/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.util.string.StringValue;

public abstract class AjaxNewWindowNotifyingBehavior
extends AbstractDefaultAjaxBehavior {
    private final String windowName;
    private static final String PARAM_WINDOW_NAME = "windowName";
    private boolean hasBeenRendered;

    public AjaxNewWindowNotifyingBehavior() {
        this(UUID.randomUUID().toString());
    }

    public AjaxNewWindowNotifyingBehavior(String windowName) {
        this.windowName = windowName;
    }

    @Override
    protected final void onBind() {
        super.onBind();
        Component component = this.getComponent();
        if (!(component instanceof WebPage)) {
            throw new WicketRuntimeException(AjaxNewWindowNotifyingBehavior.class.getName() + " can be assigned only to WebPage instances.");
        }
    }

    @Override
    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        String uuidParam = "return {'windowName': window.name}";
        attributes.getDynamicExtraParameters().add(uuidParam);
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (!this.hasBeenRendered) {
            this.hasBeenRendered = true;
            response.render(OnDomReadyHeaderItem.forScript(String.format("window.name='%s'", this.windowName)));
        }
        response.render(OnLoadHeaderItem.forScript("setTimeout(function() {" + ((Object)this.getCallbackScript()).toString() + "}, 30);"));
    }

    @Override
    protected void respond(AjaxRequestTarget target) {
        StringValue uuidParam = this.getComponent().getRequest().getRequestParameters().getParameterValue(PARAM_WINDOW_NAME);
        if (!this.windowName.equals(uuidParam.toString())) {
            this.onNewWindow(target);
        }
    }

    protected abstract void onNewWindow(AjaxRequestTarget var1);
}

