/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.DeploymentQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.ProcessDefinitionQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.ModelEntity;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Job;

public class DeploymentEntityManager
extends AbstractManager {
    public void insertDeployment(DeploymentEntity deployment) {
        this.getDbSqlSession().insert(deployment);
        for (ResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceManager().insertResource(resource);
        }
    }

    public void deleteDeployment(String deploymentId, boolean cascade) {
        String processDefinitionId;
        List processDefinitions = this.getDbSqlSession().createProcessDefinitionQuery().deploymentId(deploymentId).list();
        List models = this.getDbSqlSession().createModelQueryImpl().deploymentId(deploymentId).list();
        for (Model model : models) {
            ModelEntity modelEntity = (ModelEntity)model;
            modelEntity.setDeploymentId(null);
            this.getModelManager().updateModel(modelEntity);
        }
        if (cascade) {
            for (ProcessDefinition processDefinition : processDefinitions) {
                processDefinitionId = processDefinition.getId();
                this.getProcessInstanceManager().deleteProcessInstancesByProcessDefinition(processDefinitionId, "deleted deployment", cascade);
            }
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionId = processDefinition.getId();
            this.getIdentityLinkManager().deleteIdentityLinksByProcDef(processDefinitionId);
        }
        this.getProcessDefinitionManager().deleteProcessDefinitionsByDeploymentId(deploymentId);
        for (ProcessDefinition processDefinition : processDefinitions) {
            List<Job> timerStartJobs = Context.getCommandContext().getJobEntityManager().findJobsByConfiguration("timer-start-event", processDefinition.getKey());
            if (timerStartJobs != null && timerStartJobs.size() > 0) {
                long nrOfVersions = new ProcessDefinitionQueryImpl(Context.getCommandContext()).processDefinitionKey(processDefinition.getKey()).count();
                long nrOfProcessDefinitionsWithSameKey = 0L;
                for (ProcessDefinition p : processDefinitions) {
                    if (p.getId().equals(processDefinition) || !p.getKey().equals(processDefinition)) continue;
                    ++nrOfProcessDefinitionsWithSameKey;
                }
                if (nrOfVersions - nrOfProcessDefinitionsWithSameKey <= 1L) {
                    for (Job job : timerStartJobs) {
                        ((JobEntity)job).delete();
                    }
                }
            }
            List<EventSubscriptionEntity> findEventSubscriptionsByConfiguration = Context.getCommandContext().getEventSubscriptionEntityManager().findEventSubscriptionsByConfiguration("message", processDefinition.getId());
            for (EventSubscriptionEntity eventSubscriptionEntity : findEventSubscriptionsByConfiguration) {
                eventSubscriptionEntity.delete();
            }
        }
        this.getResourceManager().deleteResourcesByDeploymentId(deploymentId);
        this.getDbSqlSession().delete("deleteDeployment", deploymentId);
    }

    public DeploymentEntity findLatestDeploymentByName(String deploymentName) {
        List list = this.getDbSqlSession().selectList("selectDeploymentsByName", deploymentName, 0, 1);
        if (list != null && !list.isEmpty()) {
            return (DeploymentEntity)list.get(0);
        }
        return null;
    }

    public DeploymentEntity findDeploymentById(String deploymentId) {
        return (DeploymentEntity)this.getDbSqlSession().selectOne("selectDeploymentById", deploymentId);
    }

    public long findDeploymentCountByQueryCriteria(DeploymentQueryImpl deploymentQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectDeploymentCountByQueryCriteria", deploymentQuery);
    }

    public List<Deployment> findDeploymentsByQueryCriteria(DeploymentQueryImpl deploymentQuery, Page page) {
        String query = "selectDeploymentsByQueryCriteria";
        return this.getDbSqlSession().selectList("selectDeploymentsByQueryCriteria", deploymentQuery, page);
    }

    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.getDbSqlSession().getSqlSession().selectList("selectResourceNamesByDeploymentId", (Object)deploymentId);
    }

    public List<Deployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectDeploymentByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectDeploymentCountByNativeQuery", parameterMap);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

