/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.AttachmentEntity;
import org.activiti.engine.task.Attachment;

public class AttachmentEntityManager
extends AbstractManager {
    public List<Attachment> findAttachmentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectAttachmentsByProcessInstanceId", processInstanceId);
    }

    public List<Attachment> findAttachmentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectAttachmentsByTaskId", taskId);
    }

    public void deleteAttachmentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        List attachments = this.getDbSqlSession().selectList("selectAttachmentsByTaskId", taskId);
        for (AttachmentEntity attachment : attachments) {
            String contentId = attachment.getContentId();
            if (contentId != null) {
                this.getByteArrayManager().deleteByteArrayById(contentId);
            }
            this.getDbSqlSession().delete(attachment);
        }
    }

    protected void checkHistoryEnabled() {
        if (!this.getHistoryManager().isHistoryEnabled()) {
            throw new ActivitiException("In order to use attachments, history should be enabled");
        }
    }
}

