/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.exps.AbstractVal;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Raw;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.meta.ClassMetaData;

public class CoalesceExpression
extends AbstractVal {
    private final Val[] _vals;
    private ClassMetaData _meta = null;
    private Class _cast = null;
    private Value other = null;
    private ExpState otherState = null;

    public CoalesceExpression(Val[] vals) {
        this._vals = vals;
    }

    public Val[] getVal() {
        return this._vals;
    }

    public Class getType() {
        if (this._cast != null) {
            return this._cast;
        }
        Class type = this._vals[0].getType();
        for (int i = 1; i < this._vals.length; ++i) {
            type = Filters.promote((Class)type, (Class)this._vals[i].getType());
        }
        if (type == Raw.class) {
            return String.class;
        }
        return type;
    }

    @Override
    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        ExpState[] states = new ExpState[this._vals.length];
        Joins joins = null;
        for (int i = 0; i < this._vals.length; ++i) {
            states[i] = this._vals[i].initialize(sel, ctx, flags);
            joins = joins == null ? states[i].joins : sel.and(joins, states[i].joins);
        }
        return new CoalesceExpState(joins, states);
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer buf, int index) {
        CoalesceExpState cstate = (CoalesceExpState)state;
        buf.append(" COALESCE(");
        for (int i = 0; i < this._vals.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            this._vals[i].appendTo(sel, ctx, cstate.states[i], buf, 0);
        }
        buf.append(")");
    }

    @Override
    public void selectColumns(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        CoalesceExpState cstate = (CoalesceExpState)state;
        for (int i = 0; i < this._vals.length; ++i) {
            this._vals[i].selectColumns(sel, ctx, cstate.states[i], pks);
        }
    }

    @Override
    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter((Value)this);
        for (int i = 0; i < this._vals.length; ++i) {
            this._vals[i].acceptVisit(visitor);
        }
        visitor.exit((Value)this);
    }

    @Override
    public int getId() {
        return 17;
    }

    @Override
    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        CoalesceExpState cstate = (CoalesceExpState)state;
        for (int i = 0; i < this._vals.length; ++i) {
            this._vals[i].calculateValue(sel, ctx, cstate.states[i], other, otherState);
        }
    }

    @Override
    public void groupBy(Select sel, ExpContext ctx, ExpState state) {
        sel.groupBy(this.newSQLBuffer(sel, ctx, state));
    }

    @Override
    public int length(Select sel, ExpContext ctx, ExpState state) {
        return 1;
    }

    private SQLBuffer newSQLBuffer(Select sel, ExpContext ctx, ExpState state) {
        this.calculateValue(sel, ctx, state, (Val)this.other, this.otherState);
        SQLBuffer buf = new SQLBuffer(ctx.store.getDBDictionary());
        this.appendTo(sel, ctx, state, buf, 0);
        return buf;
    }

    @Override
    public Object load(ExpContext ctx, ExpState state, Result res) throws SQLException {
        return Filters.convert((Object)res.getObject(this, 1012, null), (Class)this.getType());
    }

    @Override
    public void orderBy(Select sel, ExpContext ctx, ExpState state, boolean asc) {
        sel.orderBy(this.newSQLBuffer(sel, ctx, state), asc, false, this.getSelectAs());
    }

    @Override
    public void select(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        sel.select(this.newSQLBuffer(sel, ctx, state), (Object)this);
    }

    public ClassMetaData getMetaData() {
        return this._meta;
    }

    public void setImplicitType(Class type) {
        this._cast = type;
    }

    public void setMetaData(ClassMetaData meta) {
        this._meta = meta;
    }

    public void setOtherPath(Value other) {
        this.other = other;
    }

    public Value getOtherPath() {
        return this.other;
    }

    public void setOtherState(ExpState otherState) {
        this.otherState = otherState;
    }

    public ExpState getOtherState() {
        return this.otherState;
    }

    private static class CoalesceExpState
    extends ExpState {
        public ExpState[] states;

        public CoalesceExpState(Joins joins, ExpState[] states) {
            super(joins);
            this.states = states;
        }
    }
}

