/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.caching;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.cocoon.pipeline.caching.AbstractCacheValue;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.util.StringRepresentation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompleteCacheValue
extends AbstractCacheValue {
    private static final long serialVersionUID = 1L;
    private final Log logger = LogFactory.getLog(this.getClass());
    private byte[] content;

    public CompleteCacheValue(byte[] content, CacheKey cacheKey) {
        super(cacheKey);
        this.content = content;
    }

    public Object getValue() {
        return this.content;
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.content = ((String)value).getBytes();
        } else {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
                objectOut.writeObject(value);
                objectOut.flush();
                objectOut.close();
            }
            catch (IOException e) {
                this.logger.error((Object)("Some thing goes wrong during calculating setting value of: " + this.getCacheKey()), (Throwable)e);
                return;
            }
            this.content = byteOut.toByteArray();
        }
    }

    public String toString() {
        return StringRepresentation.buildString(this, "content.length=" + this.content.length, "cacheKey=" + this.getCacheKey());
    }

    public double size() {
        return this.content.length;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.content);
    }
}

