/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.logging.FaultListener;
import org.apache.cxf.logging.NoOpFaultListener;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;

public class JAXRSInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSInInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSInInterceptor.class);
    private static final String RESOURCE_METHOD = "org.apache.cxf.resource.method";
    private static final String RESOURCE_OPERATION_NAME = "org.apache.cxf.resource.operation.name";

    public JAXRSInInterceptor() {
        super("unmarshal");
    }

    public void handleMessage(Message message) {
        if (message.getExchange().get(OperationResourceInfo.class) != null) {
            return;
        }
        message.getExchange().put((Object)"org.apache.cxf.rest.message", (Object)Boolean.TRUE);
        try {
            this.processRequest(message);
        }
        catch (Fault ex) {
            this.convertExceptionToResponseIfPossible(ex.getCause(), message);
        }
        catch (RuntimeException ex) {
            this.convertExceptionToResponseIfPossible(ex, message);
        }
        Response r = (Response)message.getExchange().get(Response.class);
        if (r != null) {
            this.createOutMessage(message, r);
            message.getInterceptorChain().doInterceptStartingAt(message, OutgoingChainInterceptor.class.getName());
        }
    }

    private void processRequest(Message message) {
        ProviderFactory providerFactory = ProviderFactory.getInstance(message);
        RequestPreprocessor rp = providerFactory.getRequestPreprocessor();
        if (rp != null) {
            rp.preprocess(message, new UriInfoImpl(message, null));
            if (message.getExchange().get(Response.class) != null) {
                return;
            }
        }
        if (JAXRSUtils.runContainerRequestFilters(providerFactory, message, true, null)) {
            return;
        }
        String httpMethod = HttpUtils.getProtocolHeader(message, "org.apache.cxf.request.method", "POST", true);
        String rawPath = HttpUtils.getPathToMatch(message, true);
        Map protocolHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        String requestContentType = null;
        List ctHeaderValues = (List)protocolHeaders.get("Content-Type");
        if (ctHeaderValues != null) {
            requestContentType = (String)ctHeaderValues.get(0);
            message.put((Object)"Content-Type", (Object)requestContentType);
        }
        if (requestContentType == null && (requestContentType = (String)message.get((Object)"Content-Type")) == null) {
            requestContentType = "*/*";
        }
        String acceptTypes = null;
        List acceptHeaderValues = (List)protocolHeaders.get("Accept");
        if (acceptHeaderValues != null) {
            acceptTypes = (String)acceptHeaderValues.get(0);
            message.put((Object)"Accept", (Object)acceptTypes);
        }
        if (acceptTypes == null && (acceptTypes = HttpUtils.getProtocolHeader(message, "Accept", null)) == null) {
            acceptTypes = "*/*";
            message.put((Object)"Accept", (Object)acceptTypes);
        }
        List<MediaType> acceptContentTypes = null;
        try {
            acceptContentTypes = JAXRSUtils.sortMediaTypes(acceptTypes, "q");
        }
        catch (IllegalArgumentException ex) {
            throw new NotAcceptableException();
        }
        message.getExchange().put((Object)"Accept", acceptContentTypes);
        Service service = (Service)message.getExchange().get(Service.class);
        List<ClassResourceInfo> resources = ((JAXRSServiceImpl)service).getClassResourceInfos();
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        ClassResourceInfo resource = JAXRSUtils.selectResourceClass(resources, rawPath, values, message);
        if (resource == null) {
            org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("NO_ROOT_EXC", BUNDLE, new Object[]{message.get((Object)"org.apache.cxf.request.uri"), rawPath});
            LOG.warning(errorMsg.toString());
            Response resp = JAXRSUtils.createResponse(null, message, errorMsg.toString(), Response.Status.NOT_FOUND.getStatusCode(), false);
            throw new NotFoundException(resp);
        }
        message.getExchange().put((Object)"root.resource.class", (Object)resource);
        OperationResourceInfo ori = null;
        boolean operChecked = false;
        List<ProviderInfo<RequestHandler>> shs = providerFactory.getRequestHandlers();
        for (ProviderInfo<RequestHandler> sh : shs) {
            if (ori == null && !operChecked) {
                try {
                    ori = JAXRSUtils.findTargetMethod(resource, message, httpMethod, values, requestContentType, acceptContentTypes, false);
                    this.setExchangeProperties(message, ori, values, resources.size());
                }
                catch (WebApplicationException ex) {
                    operChecked = true;
                }
            }
            InjectionUtils.injectContexts(sh.getProvider(), sh, message);
            Response response = sh.getProvider().handleRequest(message, resource);
            if (response == null) continue;
            message.getExchange().put(Response.class, (Object)response);
            return;
        }
        if (ori == null) {
            try {
                ori = JAXRSUtils.findTargetMethod(resource, message, httpMethod, values, requestContentType, acceptContentTypes, true);
                this.setExchangeProperties(message, ori, values, resources.size());
            }
            catch (WebApplicationException ex) {
                if (JAXRSUtils.noResourceMethodForOptions(ex.getResponse(), httpMethod)) {
                    Response response = JAXRSUtils.createResponse(resource, null, null, 200, true);
                    message.getExchange().put(Response.class, (Object)response);
                    return;
                }
                throw ex;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Request path is: " + rawPath);
            LOG.fine("Request HTTP method is: " + httpMethod);
            LOG.fine("Request contentType is: " + requestContentType);
            LOG.fine("Accept contentType is: " + acceptTypes);
            LOG.fine("Found operation: " + ori.getMethodToInvoke().getName());
        }
        this.setExchangeProperties(message, ori, values, resources.size());
        if (JAXRSUtils.runContainerRequestFilters(providerFactory, message, false, ori.getNameBindings())) {
            return;
        }
        try {
            List<Object> params = JAXRSUtils.processParameters(ori, values, message);
            message.setContent(List.class, params);
        }
        catch (IOException ex) {
            this.convertExceptionToResponseIfPossible(ex, message);
        }
    }

    private void convertExceptionToResponseIfPossible(Throwable ex, Message message) {
        Response excResponse = JAXRSUtils.convertFaultToResponse(ex, message);
        if (excResponse == null) {
            ProviderFactory.getInstance(message).clearThreadLocalProxies();
            message.getExchange().put((Object)Message.PROPOGATE_EXCEPTION, (Object)JAXRSUtils.propogateException(message));
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new InternalServerErrorException(ex);
        }
        message.getExchange().put(Response.class, (Object)excResponse);
    }

    private void setExchangeProperties(Message message, OperationResourceInfo ori, MultivaluedMap<String, String> values, int numberOfResources) {
        message.getExchange().put(OperationResourceInfo.class, (Object)ori);
        message.put((Object)RESOURCE_METHOD, (Object)ori.getMethodToInvoke());
        message.put((Object)"jaxrs.template.parameters", values);
        String plainOperationName = ori.getMethodToInvoke().getName();
        if (numberOfResources > 1) {
            plainOperationName = ori.getClassResourceInfo().getServiceClass().getSimpleName() + "#" + plainOperationName;
        }
        message.getExchange().put((Object)RESOURCE_OPERATION_NAME, (Object)plainOperationName);
        boolean oneway = ori.isOneway() || MessageUtils.isTrue((Object)HttpUtils.getProtocolHeader(message, "OnewayRequest", null));
        message.getExchange().setOneWay(oneway);
    }

    public void handleFault(Message message) {
        super.handleFault(message);
        Object mapProp = message.getContextualProperty("map.cxf.interceptor.fault");
        if (MessageUtils.isTrue((Object)mapProp)) {
            Response r;
            Throwable ex = (Throwable)message.getContent(Exception.class);
            if (ex instanceof Fault) {
                ex = ((Fault)ex).getCause();
            }
            if ((r = JAXRSUtils.convertFaultToResponse(ex, message)) != null) {
                message.removeContent(Exception.class);
                message.getInterceptorChain().setFaultObserver(null);
                if (message.getContextualProperty(FaultListener.class.getName()) == null) {
                    message.put((Object)FaultListener.class.getName(), (Object)new NoOpFaultListener());
                }
                this.createOutMessage(message, r);
                for (Interceptor inInterceptor : message.getInterceptorChain()) {
                    if (inInterceptor.getClass() != OutgoingChainInterceptor.class) continue;
                    ((OutgoingChainInterceptor)inInterceptor).handleMessage(message);
                    return;
                }
            }
        }
        LOG.fine("Cleanup thread local variables");
        Object rootInstance = message.getExchange().remove((Object)"service.root.instance");
        Object rootProvider = message.getExchange().remove((Object)"service.root.provider");
        if (rootInstance != null && rootProvider != null) {
            try {
                ((ResourceProvider)rootProvider).releaseInstance(message, rootInstance);
            }
            catch (Throwable tex) {
                LOG.warning("Exception occurred during releasing the service instance, " + tex.getMessage());
            }
        }
        ProviderFactory.getInstance(message).clearThreadLocalProxies();
        ClassResourceInfo cri = (ClassResourceInfo)message.getExchange().get((Object)"root.resource.class");
        if (cri != null) {
            cri.clearThreadLocalProxies();
        }
    }

    private Message createOutMessage(Message inMessage, Response r) {
        Endpoint e = (Endpoint)inMessage.getExchange().get(Endpoint.class);
        MessageImpl mout = new MessageImpl();
        mout.setContent(List.class, (Object)new MessageContentsList(new Object[]{r}));
        mout.setExchange(inMessage.getExchange());
        mout = e.getBinding().createMessage((Message)mout);
        mout.setInterceptorChain(OutgoingChainInterceptor.getOutInterceptorChain((Exchange)inMessage.getExchange()));
        inMessage.getExchange().setOutMessage((Message)mout);
        return mout;
    }
}

