/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.form.DefaultStartFormHandler;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.apache.commons.lang.StringUtils;

public class StartEventParseHandler
extends AbstractActivityBpmnParseHandler<StartEvent> {
    public static final String PROPERTYNAME_INITIATOR_VARIABLE_NAME = "initiatorVariableName";
    public static final String PROPERTYNAME_INITIAL = "initial";

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return StartEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, StartEvent startEvent) {
        ActivityImpl startEventActivity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)startEvent, "startEvent");
        ScopeImpl scope = bpmnParse.getCurrentScope();
        if (scope instanceof ProcessDefinitionEntity) {
            this.createProcessDefinitionStartEvent(bpmnParse, startEventActivity, startEvent, (ProcessDefinitionEntity)scope);
            this.selectInitial(bpmnParse, startEventActivity, startEvent, (ProcessDefinitionEntity)scope);
            this.createStartFormHandlers(bpmnParse, startEvent, (ProcessDefinitionEntity)scope);
        } else {
            this.createScopeStartEvent(bpmnParse, startEventActivity, startEvent);
        }
    }

    protected void selectInitial(BpmnParse bpmnParse, ActivityImpl startEventActivity, StartEvent startEvent, ProcessDefinitionEntity processDefinition) {
        if (processDefinition.getInitial() == null) {
            processDefinition.setInitial(startEventActivity);
        } else if (!startEventActivity.getProperty("type").equals("messageStartEvent")) {
            String currentInitialType = (String)processDefinition.getInitial().getProperty("type");
            if (currentInitialType.equals("messageStartEvent")) {
                processDefinition.setInitial(startEventActivity);
            } else {
                bpmnParse.getBpmnModel().addProblem("multiple none start events or timer start events not supported on process definition.", (BaseElement)startEvent);
            }
        }
    }

    protected void createStartFormHandlers(BpmnParse bpmnParse, StartEvent startEvent, ProcessDefinitionEntity processDefinition) {
        if (processDefinition.getInitial() != null && startEvent.getId().equals(processDefinition.getInitial().getId())) {
            DefaultStartFormHandler startFormHandler = new DefaultStartFormHandler();
            startFormHandler.parseConfiguration(startEvent.getFormProperties(), startEvent.getFormKey(), bpmnParse.getDeployment(), processDefinition);
            processDefinition.setStartFormHandler(startFormHandler);
        }
    }

    protected void createProcessDefinitionStartEvent(BpmnParse bpmnParse, ActivityImpl startEventActivity, StartEvent startEvent, ProcessDefinitionEntity processDefinition) {
        if (StringUtils.isNotEmpty((String)startEvent.getInitiator())) {
            processDefinition.setProperty(PROPERTYNAME_INITIATOR_VARIABLE_NAME, startEvent.getInitiator());
        }
        startEventActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createNoneStartEventActivityBehavior(startEvent));
        if (startEvent.getEventDefinitions().size() > 0) {
            EventDefinition eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0);
            if (eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof MessageEventDefinition) {
                bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, (BaseElement)eventDefinition);
            } else {
                bpmnParse.getBpmnModel().addProblem("Unsupported event definition on start event", (BaseElement)eventDefinition);
            }
        }
    }

    protected void createScopeStartEvent(BpmnParse bpmnParse, ActivityImpl startEventActivity, StartEvent startEvent) {
        boolean isTriggeredByEvent;
        ScopeImpl scope = bpmnParse.getCurrentScope();
        Object triggeredByEvent = scope.getProperty("triggeredByEvent");
        boolean bl = isTriggeredByEvent = triggeredByEvent != null && (Boolean)triggeredByEvent == true;
        if (isTriggeredByEvent) {
            EventSubProcessStartEventActivityBehavior activityBehavior = bpmnParse.getActivityBehaviorFactory().createEventSubProcessStartEventActivityBehavior(startEvent, startEventActivity.getId());
            startEventActivity.setActivityBehavior(activityBehavior);
            if (startEvent.getEventDefinitions().size() > 0) {
                EventDefinition eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0);
                if (eventDefinition instanceof ErrorEventDefinition || eventDefinition instanceof MessageEventDefinition || eventDefinition instanceof SignalEventDefinition) {
                    bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, (BaseElement)eventDefinition);
                } else {
                    bpmnParse.getBpmnModel().addProblem("start event of event subprocess must be of type 'error', 'message' or 'signal' ", (BaseElement)startEvent);
                }
            }
        } else {
            if (startEvent.getEventDefinitions().size() > 0) {
                bpmnParse.getBpmnModel().addProblem("event definitions only allowed on start event if subprocess is an event subprocess", (BaseElement)startEvent);
            }
            if (scope.getProperty(PROPERTYNAME_INITIAL) == null) {
                scope.setProperty(PROPERTYNAME_INITIAL, startEventActivity);
                startEventActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createNoneStartEventActivityBehavior(startEvent));
            } else {
                bpmnParse.getBpmnModel().addProblem("multiple start events not supported for subprocess", (BaseElement)bpmnParse.getCurrentSubProcess());
            }
        }
    }
}

