/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import java.util.Collection;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AbstractAjaxResponse;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlAjaxResponse
extends AbstractAjaxResponse {
    private static final Logger LOG = LoggerFactory.getLogger(XmlAjaxResponse.class);
    public static final String START_ROOT_ELEMENT = "<ajax-response>";
    public static final String END_ROOT_ELEMENT = "</ajax-response>";

    public XmlAjaxResponse(Page page) {
        super(page);
    }

    @Override
    public void setContentType(WebResponse response, String encoding) {
        response.setContentType("text/xml; charset=" + encoding);
    }

    @Override
    protected void writeHeader(Response response, String encoding) {
        response.write((CharSequence)"<?xml version=\"1.0\" encoding=\"");
        response.write((CharSequence)encoding);
        response.write((CharSequence)"\"?>");
        response.write((CharSequence)START_ROOT_ELEMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeComponent(Response response, String markupId, Component component, String encoding) {
        if (component.getRenderBodyOnly()) {
            throw new IllegalStateException("Ajax render cannot be called on component that has setRenderBodyOnly enabled. Component: " + component.toString());
        }
        component.setOutputMarkupId(true);
        Page page = component.findParent(Page.class);
        if (page == null) {
            LOG.warn("Component '{}' with markupid: '{}' not rendered because it was already removed from page", (Object)component, (Object)markupId);
            return;
        }
        Response oldResponse = RequestCycle.get().setResponse(this.encodingBodyResponse);
        try {
            this.encodingBodyResponse.reset();
            page.startComponentRender(component);
            try {
                component.prepareForRender();
                this.writeHeaderContribution(response, component);
            }
            catch (RuntimeException e) {
                try {
                    component.afterRender();
                }
                catch (RuntimeException e2) {
                    // empty catch block
                }
                this.encodingBodyResponse.reset();
                throw e;
            }
            try {
                component.render();
            }
            catch (RuntimeException e) {
                this.encodingBodyResponse.reset();
                throw e;
            }
            page.endComponentRender(component);
        }
        finally {
            RequestCycle.get().setResponse(oldResponse);
        }
        response.write((CharSequence)"<component id=\"");
        response.write((CharSequence)markupId);
        response.write((CharSequence)"\" ");
        if (this.encodingBodyResponse.isContentsEncoded()) {
            response.write((CharSequence)" encoding=\"");
            response.write((CharSequence)this.getEncodingName());
            response.write((CharSequence)"\" ");
        }
        response.write((CharSequence)"><![CDATA[");
        response.write(this.encodingBodyResponse.getContents());
        response.write((CharSequence)"]]></component>");
        this.encodingBodyResponse.reset();
    }

    @Override
    protected void writeFooter(Response response, String encoding) {
        response.write((CharSequence)END_ROOT_ELEMENT);
    }

    @Override
    protected void writeHeaderContribution(Response response) {
        if (this.encodingHeaderResponse.getContents().length() != 0) {
            response.write((CharSequence)"<header-contribution");
            if (this.encodingHeaderResponse.isContentsEncoded()) {
                response.write((CharSequence)" encoding=\"");
                response.write((CharSequence)this.getEncodingName());
                response.write((CharSequence)"\" ");
            }
            response.write((CharSequence)"><![CDATA[<head xmlns:wicket=\"http://wicket.apache.org\">");
            response.write(this.encodingHeaderResponse.getContents());
            response.write((CharSequence)"</head>]]>");
            response.write((CharSequence)"</header-contribution>");
        }
    }

    @Override
    protected void writeNormalEvaluations(Response response, Collection<CharSequence> scripts) {
        this.writeEvaluations(response, "evaluate", scripts);
    }

    @Override
    protected void writePriorityEvaluations(Response response, Collection<CharSequence> scripts) {
        this.writeEvaluations(response, "priority-evaluate", scripts);
    }

    private void writeEvaluations(Response response, String elementName, Collection<CharSequence> scripts) {
        if (scripts.size() > 0) {
            StringBuilder combinedScript = new StringBuilder(1024);
            for (CharSequence script : scripts) {
                combinedScript.append("(function(){").append(script).append("})();");
            }
            this.writeEvaluation(elementName, response, combinedScript);
        }
    }

    private void writeEvaluation(String invocation, Response response, CharSequence js) {
        boolean encoded = false;
        CharSequence javascript = js;
        if (XmlAjaxResponse.needsEncoding(js)) {
            encoded = true;
            javascript = XmlAjaxResponse.encode(js);
        }
        response.write((CharSequence)"<");
        response.write((CharSequence)invocation);
        if (encoded) {
            response.write((CharSequence)" encoding=\"");
            response.write((CharSequence)this.getEncodingName());
            response.write((CharSequence)"\"");
        }
        response.write((CharSequence)">");
        response.write((CharSequence)"<![CDATA[");
        response.write(javascript);
        response.write((CharSequence)"]]>");
        response.write((CharSequence)"</");
        response.write((CharSequence)invocation);
        response.write((CharSequence)">");
        this.encodingBodyResponse.reset();
    }
}

