/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.optional.pipeline.components.sax.jaxb;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PluralStemmer {
    private static final PluralStemmer INSTANCE = new PluralStemmer();
    private final Map<Pattern, String> rules = new LinkedHashMap<Pattern, String>();

    public static PluralStemmer getInstance() {
        return INSTANCE;
    }

    private PluralStemmer() {
        this.addIdentityRule("advice");
        this.addIdentityRule("air");
        this.addIdentityRule("alcohol");
        this.addIdentityRule("art");
        this.addIdentityRule("beef");
        this.addIdentityRule("blood");
        this.addIdentityRule("butter");
        this.addIdentityRule("cheese");
        this.addIdentityRule("chocolate");
        this.addIdentityRule("coffee");
        this.addIdentityRule("confusion");
        this.addIdentityRule("cotton");
        this.addIdentityRule("education");
        this.addIdentityRule("electricity");
        this.addIdentityRule("entertainment");
        this.addIdentityRule("equipment");
        this.addIdentityRule("experience");
        this.addIdentityRule("fiction");
        this.addIdentityRule("flour");
        this.addIdentityRule("food");
        this.addIdentityRule("forgiveness");
        this.addIdentityRule("furniture");
        this.addIdentityRule("gold");
        this.addIdentityRule("grass");
        this.addIdentityRule("ground");
        this.addIdentityRule("happiness");
        this.addIdentityRule("history");
        this.addIdentityRule("homework");
        this.addIdentityRule("honey");
        this.addIdentityRule("hope");
        this.addIdentityRule("ice");
        this.addIdentityRule("information");
        this.addIdentityRule("jam");
        this.addIdentityRule("juice");
        this.addIdentityRule("knowledge");
        this.addIdentityRule("lamb");
        this.addIdentityRule("lightning");
        this.addIdentityRule("literature");
        this.addIdentityRule("love");
        this.addIdentityRule("luck");
        this.addIdentityRule("luggage");
        this.addIdentityRule("meat");
        this.addIdentityRule("milk");
        this.addIdentityRule("mist");
        this.addIdentityRule("money");
        this.addIdentityRule("music");
        this.addIdentityRule("news");
        this.addIdentityRule("noise");
        this.addIdentityRule("oil");
        this.addIdentityRule("oxygen");
        this.addIdentityRule("paper");
        this.addIdentityRule("patience");
        this.addIdentityRule("pay");
        this.addIdentityRule("peace");
        this.addIdentityRule("pepper");
        this.addIdentityRule("petrol");
        this.addIdentityRule("plastic");
        this.addIdentityRule("pork");
        this.addIdentityRule("power");
        this.addIdentityRule("pressure");
        this.addIdentityRule("rain");
        this.addIdentityRule("rice");
        this.addIdentityRule("sadness");
        this.addIdentityRule("salt");
        this.addIdentityRule("sand");
        this.addIdentityRule("shopping");
        this.addIdentityRule("silver");
        this.addIdentityRule("snow");
        this.addIdentityRule("space");
        this.addIdentityRule("speed");
        this.addIdentityRule("steam");
        this.addIdentityRule("sugar");
        this.addIdentityRule("sunshine");
        this.addIdentityRule("tea");
        this.addIdentityRule("tennis");
        this.addIdentityRule("time");
        this.addIdentityRule("toothpaste");
        this.addIdentityRule("traffic");
        this.addIdentityRule("trousers");
        this.addIdentityRule("vinegar");
        this.addIdentityRule("water");
        this.addIdentityRule("weather");
        this.addIdentityRule("wine");
        this.addIdentityRule("wood");
        this.addIdentityRule("wool");
        this.addIdentityRule("work");
        this.addRule("person", "people");
        this.addRule("man", "men");
        this.addRule("child", "children");
        this.addRule("sex", "sexes");
        this.addRule("move", "moves");
        this.addRule("(ax|test)is$", "$1es");
        this.addRule("(octop|vir)us$", "$1i");
        this.addRule("(alias|status)$", "$1es");
        this.addRule("(bu)s$", "$1ses");
        this.addRule("(buffal|tomat)o$", "$1oes");
        this.addRule("([ti])um$", "$1a");
        this.addRule("sis$", "ses");
        this.addRule("(?:([^f])fe|([lr])f)$", "$1$2ves");
        this.addRule("(hive)$", "$1s");
        this.addRule("([^aeiouy]|qu)y$", "$1ies");
        this.addRule("(x|ch|ss|sh)$", "$1es");
        this.addRule("(matr|vert|ind)(?:ix|ex)$", "$1ices");
        this.addRule("([m|l])ouse$", "$1ice");
        this.addRule("^(ox)$", "$1en");
        this.addRule("(quiz)$", "$1zes");
        this.addRule("s$", "s");
        this.addRule("$", "s");
    }

    private void addIdentityRule(String pattern) {
        this.addRule(pattern, "$0");
    }

    private void addRule(String pattern, String rule) {
        this.rules.put(Pattern.compile(pattern, 2), rule);
    }

    public String toPlural(String xmlRootElementName) {
        for (Map.Entry<Pattern, String> replacer : this.rules.entrySet()) {
            Matcher matcher = replacer.getKey().matcher(xmlRootElementName);
            if (!matcher.find()) continue;
            return matcher.replaceFirst(replacer.getValue());
        }
        return xmlRootElementName;
    }
}

