/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.autocomplete;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.IWrappedHeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractAutoCompleteBehavior
extends AbstractDefaultAjaxBehavior {
    private static final ResourceReference AUTOCOMPLETE_JS = new JavaScriptResourceReference(AutoCompleteBehavior.class, "wicket-autocomplete.js");
    private static final long serialVersionUID = 1L;
    protected AutoCompleteSettings settings;

    public AbstractAutoCompleteBehavior() {
        this(new AutoCompleteSettings());
    }

    public AbstractAutoCompleteBehavior(AutoCompleteSettings settings) {
        if (settings == null) {
            settings = new AutoCompleteSettings();
        }
        this.settings = settings;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        this.renderAutocompleteHead(response);
    }

    private void renderAutocompleteHead(IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)AUTOCOMPLETE_JS));
        String id = this.getComponent().getMarkupId();
        String indicatorId = this.findIndicatorId();
        indicatorId = Strings.isEmpty((CharSequence)indicatorId) ? "null" : "'" + indicatorId + "'";
        String initJS = String.format("new Wicket.AutoComplete('%s','%s',%s,%s);", id, this.getCallbackUrl(), this.constructSettingsJS(), indicatorId);
        OnDomReadyHeaderItem onDomReady = OnDomReadyHeaderItem.forScript((CharSequence)initJS);
        response.render((HeaderItem)new WrappedHeaderItem(onDomReady));
    }

    protected final String constructSettingsJS() {
        StringBuilder sb = new StringBuilder();
        sb.append("{preselect: ").append(this.settings.getPreselect());
        sb.append(",maxHeight: ").append(this.settings.getMaxHeightInPx());
        sb.append(",adjustInputWidth: ").append(this.settings.isAdjustInputWidth());
        sb.append(",useSmartPositioning: ").append(this.settings.getUseSmartPositioning());
        sb.append(",useHideShowCoveredIEFix: ").append(this.settings.getUseHideShowCoveredIEFix());
        sb.append(",showListOnEmptyInput: ").append(this.settings.getShowListOnEmptyInput());
        sb.append(",ignoreBordersWhenPositioning: ").append(this.settings.getIgnoreBordersWhenPositioning());
        sb.append(",showListOnFocusGain: ").append(this.settings.getShowListOnFocusGain());
        sb.append(",throttleDelay: ").append(this.settings.getThrottleDelay());
        sb.append(",minInputLength: ").append(this.settings.getMinInputLength());
        sb.append(",parameterName: '").append(this.settings.getParameterName()).append('\'');
        sb.append(",showCompleteListOnFocusGain: ").append(this.settings.getShowCompleteListOnFocusGain());
        if (this.settings.getCssClassName() != null) {
            sb.append(",className: '").append(this.settings.getCssClassName()).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }

    protected abstract void onRequest(String var1, RequestCycle var2);

    protected void respond(AjaxRequestTarget target) {
        RequestCycle requestCycle = RequestCycle.get();
        String val = requestCycle.getRequest().getRequestParameters().getParameterValue(this.settings.getParameterName()).toOptionalString();
        this.onRequest(val, requestCycle);
    }

    private static final class WrappedHeaderItem
    extends HeaderItem
    implements IWrappedHeaderItem {
        private final OnDomReadyHeaderItem item;

        private WrappedHeaderItem(OnDomReadyHeaderItem onDomReady) {
            this.item = onDomReady;
        }

        public void render(Response response) {
            this.item.render(response);
        }

        public Iterable<?> getRenderTokens() {
            return this.item.getRenderTokens();
        }

        public HeaderItem getWrapped() {
            return this.item;
        }
    }
}

