/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.export;

import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.export.FieldExtensionExport;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.HasExecutionListeners;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.UserTask;
import org.apache.commons.lang.StringUtils;

public class ActivitiListenerExport
implements BpmnXMLConstants {
    public static boolean writeListeners(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        if (element instanceof HasExecutionListeners) {
            didWriteExtensionStartElement = ActivitiListenerExport.writeListeners("executionListener", ((HasExecutionListeners)element).getExecutionListeners(), didWriteExtensionStartElement, xtw);
        }
        if (element instanceof UserTask) {
            didWriteExtensionStartElement = ActivitiListenerExport.writeListeners("taskListener", ((UserTask)element).getTaskListeners(), didWriteExtensionStartElement, xtw);
        }
        return didWriteExtensionStartElement;
    }

    private static boolean writeListeners(String xmlElementName, List<ActivitiListener> listenerList, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        if (listenerList != null) {
            for (ActivitiListener listener : listenerList) {
                if (!StringUtils.isNotEmpty((String)listener.getEvent())) continue;
                if (!didWriteExtensionStartElement) {
                    xtw.writeStartElement("extensionElements");
                    didWriteExtensionStartElement = true;
                }
                xtw.writeStartElement("activiti", xmlElementName, "http://activiti.org/bpmn");
                BpmnXMLUtil.writeDefaultAttribute("event", listener.getEvent(), xtw);
                if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(listener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("class", listener.getImplementation(), xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(listener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("expression", listener.getImplementation(), xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(listener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("delegateExpression", listener.getImplementation(), xtw);
                }
                FieldExtensionExport.writeFieldExtensions(listener.getFieldExtensions(), true, xtw);
                xtw.writeEndElement();
            }
        }
        return didWriteExtensionStartElement;
    }
}

