/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.caching;

import org.apache.cocoon.pipeline.caching.AbstractCacheKey;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.util.MurmurHashCodeBuilder;

public final class ExpiresCacheKey
extends AbstractCacheKey {
    private static final long serialVersionUID = 1L;
    private final CacheKey cacheKey;
    private final long timestamp;
    private final long expirationTimestamp;

    public ExpiresCacheKey(CacheKey cacheKey, String expires) {
        this.cacheKey = cacheKey;
        this.timestamp = System.currentTimeMillis();
        this.expirationTimestamp = this.timestamp + Long.parseLong(expires) * 1000L;
    }

    public boolean isValid(CacheKey cacheKey) {
        if (!(cacheKey instanceof ExpiresCacheKey)) {
            return false;
        }
        ExpiresCacheKey other = (ExpiresCacheKey)cacheKey;
        if (this.expirationTimestamp > other.timestamp) {
            return true;
        }
        return this.cacheKey.isValid(other.cacheKey);
    }

    public long getLastModified() {
        return this.cacheKey.getLastModified();
    }

    public long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExpiresCacheKey)) {
            return false;
        }
        ExpiresCacheKey other = (ExpiresCacheKey)obj;
        return this.cacheKey.equals(other.cacheKey);
    }

    public int hashCode() {
        return new MurmurHashCodeBuilder().append(this.getClass().getName()).append(this.cacheKey.hashCode()).toHashCode();
    }
}

