/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.caching;

import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.pipeline.caching.AbstractCacheKey;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.util.MurmurHashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterCacheKey
extends AbstractCacheKey {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> parameters;

    public ParameterCacheKey() {
        this(new HashMap<String, String>());
    }

    public ParameterCacheKey(Map<String, String> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("A map of parameters has to be passed.");
        }
        this.parameters = parameters;
    }

    public ParameterCacheKey(String name, Map<?, ?> value) {
        this();
        this.addParameter(name, value);
    }

    public ParameterCacheKey(String name, String value) {
        this();
        this.addParameter(name, value);
    }

    public void addParameter(String name, boolean value) {
        this.parameters.put(name, Boolean.toString(value));
    }

    public void addParameter(String name, int value) {
        this.parameters.put(name, Integer.toString(value));
    }

    public void addParameter(String name, Map<?, ?> value) {
        for (Map.Entry<?, ?> object : value.entrySet()) {
            this.parameters.put(name + "_" + object.getKey().toString(), object.getValue().toString());
        }
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParameterCacheKey)) {
            return false;
        }
        ParameterCacheKey other = (ParameterCacheKey)obj;
        return this.parameters != null && ((Object)this.parameters).equals(other.parameters);
    }

    @Override
    public long getLastModified() {
        return -1L;
    }

    public int hashCode() {
        MurmurHashCodeBuilder hashCodeBuilder = new MurmurHashCodeBuilder();
        for (Map.Entry<String, String> parameterEntry : this.parameters.entrySet()) {
            hashCodeBuilder.append(parameterEntry.getKey()).append(parameterEntry.getValue());
        }
        return hashCodeBuilder.toHashCode();
    }

    @Override
    public boolean isValid(CacheKey cacheKey) {
        return this.equals(cacheKey);
    }
}

