/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.caching;

import java.io.IOException;
import java.io.OutputStream;

public class CachingOutputStream
extends OutputStream {
    private byte[] buffer;
    private int length;
    private OutputStream outputStream;

    public CachingOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.buffer = new byte[1024];
        this.length = 0;
    }

    public void close() throws IOException {
        this.outputStream.close();
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public byte[] getContent() {
        byte[] result = new byte[this.length];
        System.arraycopy(this.buffer, 0, result, 0, this.length);
        return result;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        if (this.length + len >= this.buffer.length) {
            byte[] nextBuffer = new byte[this.length + len + 1024];
            System.arraycopy(this.buffer, 0, nextBuffer, 0, this.buffer.length);
            this.buffer = nextBuffer;
        }
        System.arraycopy(b, off, this.buffer, this.length, len);
        this.length += len;
    }

    public void write(int b) throws IOException {
        this.outputStream.write(b);
        if (this.length + 1 == this.buffer.length) {
            byte[] nextBuffer = new byte[this.buffer.length + 1024];
            System.arraycopy(this.buffer, 0, nextBuffer, 0, this.buffer.length);
            this.buffer = nextBuffer;
        }
        this.buffer[this.length] = (byte)b;
        ++this.length;
    }
}

