/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.hyphenation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.hyphenation.Hyphenation;
import org.apache.fop.hyphenation.HyphenationException;
import org.apache.fop.hyphenation.HyphenationTree;
import org.apache.fop.hyphenation.HyphenationTreeCache;
import org.apache.fop.hyphenation.HyphenationTreeResolver;
import org.xml.sax.InputSource;

public final class Hyphenator {
    protected static final Log log = LogFactory.getLog(Hyphenator.class);
    private static HyphenationTreeCache hTreeCache = null;
    private static boolean statisticsDump = false;

    private Hyphenator() {
    }

    public static synchronized HyphenationTreeCache getHyphenationTreeCache() {
        if (hTreeCache == null) {
            hTreeCache = new HyphenationTreeCache();
        }
        return hTreeCache;
    }

    public static HyphenationTree getHyphenationTree(String lang, String country, HyphenationTreeResolver resolver, Map hyphPatNames) {
        String llKey;
        String llccKey = HyphenationTreeCache.constructLlccKey(lang, country);
        HyphenationTreeCache cache = Hyphenator.getHyphenationTreeCache();
        if (cache.isMissing(llccKey)) {
            return null;
        }
        HyphenationTree hTree = Hyphenator.getHyphenationTree2(lang, country, resolver, hyphPatNames);
        if (hTree == null && country != null && !country.equals("none") && !cache.isMissing(llKey = HyphenationTreeCache.constructLlccKey(lang, null))) {
            hTree = Hyphenator.getHyphenationTree2(lang, null, resolver, hyphPatNames);
            if (hTree != null && log.isDebugEnabled()) {
                log.debug((Object)("Couldn't find hyphenation pattern for lang=\"" + lang + "\",country=\"" + country + "\"." + " Using general language pattern " + "for lang=\"" + lang + "\" instead."));
            }
            if (hTree == null) {
                cache.noteMissing(llKey);
            } else {
                cache.cache(llccKey, hTree);
            }
        }
        if (hTree == null) {
            cache.noteMissing(llccKey);
            log.error((Object)("Couldn't find hyphenation pattern for lang=\"" + lang + "\"" + (country != null && !country.equals("none") ? ",country=\"" + country + "\"" : "") + "."));
        }
        return hTree;
    }

    private static HyphenationTree getHyphenationTree2(String lang, String country, HyphenationTreeResolver resolver, Map hyphPatNames) {
        String llccKey = HyphenationTreeCache.constructLlccKey(lang, country);
        HyphenationTreeCache cache = Hyphenator.getHyphenationTreeCache();
        HyphenationTree hTree = Hyphenator.getHyphenationTreeCache().getHyphenationTree(lang, country);
        if (hTree != null) {
            return hTree;
        }
        String key = HyphenationTreeCache.constructUserKey(lang, country, hyphPatNames);
        if (key == null) {
            key = llccKey;
        }
        if (resolver != null) {
            hTree = Hyphenator.getUserHyphenationTree(key, resolver);
        }
        if (hTree == null) {
            hTree = Hyphenator.getFopHyphenationTree(key);
        }
        if (hTree != null) {
            cache.cache(llccKey, hTree);
        }
        return hTree;
    }

    private static InputStream getResourceStream(String key) {
        InputStream is = null;
        try {
            Method getCCL = Thread.class.getMethod("getContextClassLoader", new Class[0]);
            if (getCCL != null) {
                ClassLoader contextClassLoader = (ClassLoader)getCCL.invoke((Object)Thread.currentThread(), new Object[0]);
                is = contextClassLoader.getResourceAsStream("hyph/" + key + ".hyp");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is == null) {
            is = Hyphenator.class.getResourceAsStream("/hyph/" + key + ".hyp");
        }
        return is;
    }

    private static HyphenationTree readHyphenationTree(InputStream in) {
        HyphenationTree hTree = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(in);
            hTree = (HyphenationTree)ois.readObject();
        }
        catch (IOException ioe) {
            log.error((Object)"I/O error while loading precompiled hyphenation pattern file", (Throwable)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            log.error((Object)"Error while reading hyphenation object from file", (Throwable)cnfe);
        }
        return hTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HyphenationTree getFopHyphenationTree(String key) {
        HyphenationTree hTree = null;
        InputStream ois = null;
        InputStream is = null;
        try {
            is = Hyphenator.getResourceStream(key);
            if (is == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Couldn't find precompiled hyphenation pattern " + key + " in resources"));
                }
                HyphenationTree hyphenationTree = null;
                return hyphenationTree;
            }
            hTree = Hyphenator.readHyphenationTree(is);
        }
        finally {
            IOUtils.closeQuietly(ois);
        }
        return hTree;
    }

    public static HyphenationTree getUserHyphenationTree(String key, String hyphenDir) {
        final File baseDir = new File(hyphenDir);
        HyphenationTreeResolver resolver = new HyphenationTreeResolver(){

            public Source resolve(String href) {
                File f = new File(baseDir, href);
                return new StreamSource(f);
            }
        };
        return Hyphenator.getUserHyphenationTree(key, resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HyphenationTree getUserHyphenationTree(String key, HyphenationTreeResolver resolver) {
        Source source;
        String name;
        HyphenationTree hTree;
        block26: {
            hTree = null;
            name = key + ".hyp";
            source = resolver.resolve(name);
            if (source != null) {
                try {
                    InputStream in = null;
                    if (source instanceof StreamSource) {
                        in = ((StreamSource)source).getInputStream();
                    }
                    if (in == null) {
                        if (source.getSystemId() != null) {
                            in = new URL(source.getSystemId()).openStream();
                        } else {
                            throw new UnsupportedOperationException("Cannot load hyphenation pattern file with the supplied Source object: " + source);
                        }
                    }
                    in = new BufferedInputStream(in);
                    try {
                        hTree = Hyphenator.readHyphenationTree(in);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                    return hTree;
                }
                catch (IOException ioe) {
                    if (!log.isDebugEnabled()) break block26;
                    log.debug((Object)("I/O problem while trying to load " + name), (Throwable)ioe);
                }
            }
        }
        if ((source = resolver.resolve(name = key + ".xml")) != null) {
            hTree = new HyphenationTree();
            try {
                InputStream in = null;
                if (source instanceof StreamSource) {
                    in = ((StreamSource)source).getInputStream();
                }
                if (in == null) {
                    if (source.getSystemId() != null) {
                        in = new URL(source.getSystemId()).openStream();
                    } else {
                        throw new UnsupportedOperationException("Cannot load hyphenation pattern file with the supplied Source object: " + source);
                    }
                }
                if (!(in instanceof BufferedInputStream)) {
                    in = new BufferedInputStream(in);
                }
                try {
                    InputSource src = new InputSource(in);
                    src.setSystemId(source.getSystemId());
                    hTree.loadPatterns(src);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
                if (statisticsDump) {
                    System.out.println("Stats: ");
                    hTree.printStats();
                }
                return hTree;
            }
            catch (HyphenationException ex) {
                log.error((Object)("Can't load user patterns from XML file " + source.getSystemId() + ": " + ex.getMessage()));
                return null;
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("I/O problem while trying to load " + name), (Throwable)ioe);
                }
                return null;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Could not load user hyphenation file for '" + key + "'."));
        }
        return null;
    }

    public static Hyphenation hyphenate(String lang, String country, HyphenationTreeResolver resolver, Map hyphPatNames, String word, int leftMin, int rightMin) {
        HyphenationTree hTree = Hyphenator.getHyphenationTree(lang, country, resolver, hyphPatNames);
        if (hTree == null) {
            return null;
        }
        return hTree.hyphenate(word, leftMin, rightMin);
    }
}

