/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.pages;

import org.apache.wicket.core.request.ClientInfo;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.io.IClusterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserInfoForm
extends Panel {
    private static final Logger log = LoggerFactory.getLogger(BrowserInfoForm.class);
    private static final long serialVersionUID = 1L;

    public BrowserInfoForm(String id) {
        super(id);
        Form<ClientPropertiesBean> form = new Form<ClientPropertiesBean>("postback", new CompoundPropertyModel<ClientPropertiesBean>(new ClientPropertiesBean())){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSubmit() {
                ClientPropertiesBean propertiesBean = (ClientPropertiesBean)this.getModelObject();
                RequestCycle requestCycle = this.getRequestCycle();
                WebSession session = (WebSession)this.getSession();
                WebClientInfo clientInfo = session.getClientInfo();
                if (clientInfo == null) {
                    clientInfo = new WebClientInfo(requestCycle);
                    this.getSession().setClientInfo(clientInfo);
                }
                ClientProperties properties = clientInfo.getProperties();
                propertiesBean.merge(properties);
                BrowserInfoForm.this.afterSubmit();
            }
        };
        form.add(new TextField("navigatorAppName"));
        form.add(new TextField("navigatorAppVersion"));
        form.add(new TextField("navigatorAppCodeName"));
        form.add(new TextField("navigatorCookieEnabled"));
        form.add(new TextField("navigatorJavaEnabled"));
        form.add(new TextField("navigatorLanguage"));
        form.add(new TextField("navigatorPlatform"));
        form.add(new TextField("navigatorUserAgent"));
        form.add(new TextField("screenWidth"));
        form.add(new TextField("screenHeight"));
        form.add(new TextField("screenColorDepth"));
        form.add(new TextField("utcOffset"));
        form.add(new TextField("utcDSTOffset"));
        form.add(new TextField("browserWidth"));
        form.add(new TextField("browserHeight"));
        form.add(new TextField("hostname"));
        this.add(form);
    }

    void warnNotUsingWebClientInfo(ClientInfo clientInfo) {
        log.warn("using " + this.getClass().getName() + " makes no sense if you are not using " + WebClientInfo.class.getName() + " (you are using " + clientInfo.getClass().getName() + " instead)");
    }

    protected void afterSubmit() {
    }

    public static class ClientPropertiesBean
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private String navigatorAppCodeName;
        private String navigatorAppName;
        private String navigatorAppVersion;
        private Boolean navigatorCookieEnabled = Boolean.FALSE;
        private Boolean navigatorJavaEnabled = Boolean.FALSE;
        private String navigatorLanguage;
        private String navigatorPlatform;
        private String navigatorUserAgent;
        private String screenColorDepth;
        private String screenHeight;
        private String screenWidth;
        private String utcOffset;
        private String utcDSTOffset;
        private String browserWidth;
        private String browserHeight;
        private String hostname;

        public String getBrowserHeight() {
            return this.browserHeight;
        }

        public String getBrowserWidth() {
            return this.browserWidth;
        }

        public String getNavigatorAppCodeName() {
            return this.navigatorAppCodeName;
        }

        public String getNavigatorAppName() {
            return this.navigatorAppName;
        }

        public String getNavigatorAppVersion() {
            return this.navigatorAppVersion;
        }

        public Boolean getNavigatorCookieEnabled() {
            return this.navigatorCookieEnabled;
        }

        public Boolean getNavigatorJavaEnabled() {
            return this.navigatorJavaEnabled;
        }

        public String getNavigatorLanguage() {
            return this.navigatorLanguage;
        }

        public String getNavigatorPlatform() {
            return this.navigatorPlatform;
        }

        public String getNavigatorUserAgent() {
            return this.navigatorUserAgent;
        }

        public String getScreenColorDepth() {
            return this.screenColorDepth;
        }

        public String getScreenHeight() {
            return this.screenHeight;
        }

        public String getScreenWidth() {
            return this.screenWidth;
        }

        public String getUtcOffset() {
            return this.utcOffset;
        }

        public String getUtcDSTOffset() {
            return this.utcDSTOffset;
        }

        public void merge(ClientProperties properties) {
            properties.setNavigatorAppName(this.navigatorAppName);
            properties.setNavigatorAppVersion(this.navigatorAppVersion);
            properties.setNavigatorAppCodeName(this.navigatorAppCodeName);
            properties.setCookiesEnabled(this.navigatorCookieEnabled != null ? this.navigatorCookieEnabled : false);
            properties.setJavaEnabled(this.navigatorJavaEnabled != null ? this.navigatorJavaEnabled : false);
            properties.setNavigatorLanguage(this.navigatorLanguage);
            properties.setNavigatorPlatform(this.navigatorPlatform);
            properties.setNavigatorUserAgent(this.navigatorUserAgent);
            properties.setScreenWidth(this.getInt(this.screenWidth));
            properties.setScreenHeight(this.getInt(this.screenHeight));
            properties.setBrowserWidth(this.getInt(this.browserWidth));
            properties.setBrowserHeight(this.getInt(this.browserHeight));
            properties.setScreenColorDepth(this.getInt(this.screenColorDepth));
            properties.setUtcOffset(this.utcOffset);
            properties.setUtcDSTOffset(this.utcDSTOffset);
            properties.setHostname(this.hostname);
        }

        public void setBrowserHeight(String browserHeight) {
            this.browserHeight = browserHeight;
        }

        public void setBrowserWidth(String browserWidth) {
            this.browserWidth = browserWidth;
        }

        public void setNavigatorAppCodeName(String navigatorAppCodeName) {
            this.navigatorAppCodeName = navigatorAppCodeName;
        }

        public void setNavigatorAppName(String navigatorAppName) {
            this.navigatorAppName = navigatorAppName;
        }

        public void setNavigatorAppVersion(String navigatorAppVersion) {
            this.navigatorAppVersion = navigatorAppVersion;
        }

        public void setNavigatorCookieEnabled(Boolean navigatorCookieEnabled) {
            this.navigatorCookieEnabled = navigatorCookieEnabled;
        }

        public void setNavigatorJavaEnabled(Boolean navigatorJavaEnabled) {
            this.navigatorJavaEnabled = navigatorJavaEnabled;
        }

        public void setNavigatorLanguage(String navigatorLanguage) {
            this.navigatorLanguage = navigatorLanguage;
        }

        public void setNavigatorPlatform(String navigatorPlatform) {
            this.navigatorPlatform = navigatorPlatform;
        }

        public void setNavigatorUserAgent(String navigatorUserAgent) {
            this.navigatorUserAgent = navigatorUserAgent;
        }

        public void setScreenColorDepth(String screenColorDepth) {
            this.screenColorDepth = screenColorDepth;
        }

        public void setScreenHeight(String screenHeight) {
            this.screenHeight = screenHeight;
        }

        public void setScreenWidth(String screenWidth) {
            this.screenWidth = screenWidth;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setUtcOffset(String utcOffset) {
            this.utcOffset = utcOffset;
        }

        public void setUtcDSTOffset(String utcDSTOffset) {
            this.utcDSTOffset = utcDSTOffset;
        }

        private int getInt(String value) {
            int intValue = -1;
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return intValue;
        }
    }
}

