/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.io;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.objects.checker.AbstractObjectChecker;
import org.apache.wicket.core.util.objects.checker.CheckingObjectOutputStream;
import org.apache.wicket.core.util.objects.checker.IObjectChecker;
import org.apache.wicket.util.io.ByteArrayOutputStream;

public class SerializableChecker
extends CheckingObjectOutputStream {
    public SerializableChecker(NotSerializableException exception) throws IOException {
        this((OutputStream)new ByteArrayOutputStream(), exception);
    }

    public SerializableChecker(OutputStream outputStream, NotSerializableException exception) throws IOException {
        super(outputStream, new ObjectSerializationChecker(exception));
    }

    @Deprecated
    public static boolean isAvailable() {
        return CheckingObjectOutputStream.isAvailable();
    }

    public static class ObjectSerializationChecker
    extends AbstractObjectChecker {
        private final NotSerializableException cause;

        public ObjectSerializationChecker() {
            this((NotSerializableException)null);
        }

        public ObjectSerializationChecker(NotSerializableException cause) {
            this.cause = cause;
        }

        @Override
        public IObjectChecker.Result check(Object object) {
            IObjectChecker.Result result = IObjectChecker.Result.SUCCESS;
            if (!(object instanceof Serializable) && !Proxy.isProxyClass(object.getClass())) {
                result = new IObjectChecker.Result(IObjectChecker.Result.Status.FAILURE, "The object type is not Serializable!", this.cause);
            }
            return result;
        }
    }

    @Deprecated
    public static final class WicketNotSerializableException
    extends WicketRuntimeException {
        private static final long serialVersionUID = 1L;

        private WicketNotSerializableException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

