/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.Arrays;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.PersistentObject;

public class ByteArrayEntity
implements Serializable,
PersistentObject,
HasRevision {
    private static final long serialVersionUID = 1L;
    private static final Object PERSISTENTSTATE_NULL = new Object();
    protected String id;
    protected int revision;
    protected String name;
    protected byte[] bytes;
    protected String deploymentId;

    public ByteArrayEntity() {
    }

    public ByteArrayEntity(String name, byte[] bytes) {
        this.name = name;
        this.bytes = bytes;
    }

    public ByteArrayEntity(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public Object getPersistentState() {
        return this.bytes != null ? new ByteArray(this.bytes) : PERSISTENTSTATE_NULL;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    public static class ByteArray {
        protected byte[] bytes;

        public ByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object other) {
            if (other instanceof ByteArray) {
                ByteArray otherByteArray = (ByteArray)other;
                return Arrays.equals(this.bytes, otherByteArray.bytes);
            }
            return false;
        }
    }
}

