/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.jobexecutor.AcquiredJobs;
import org.activiti.engine.impl.jobexecutor.GetUnlockedTimersByDuedateCmd;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.impl.util.ClockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcquireJobsRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(AcquireJobsRunnable.class);
    protected final JobExecutor jobExecutor;
    protected volatile boolean isInterrupted = false;
    protected volatile boolean isJobAdded = false;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);
    protected long millisToWait = 0L;
    protected float waitIncreaseFactor = 2.0f;
    protected long maxWait = 60000L;

    public AcquireJobsRunnable(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        log.info("{} starting to acquire jobs", (Object)this.jobExecutor.getName());
        CommandExecutor commandExecutor = this.jobExecutor.getCommandExecutor();
        while (!this.isInterrupted) {
            block20: {
                int maxJobsPerAcquisition = this.jobExecutor.getMaxJobsPerAcquisition();
                try {
                    AcquiredJobs acquiredJobs = commandExecutor.execute(this.jobExecutor.getAcquireJobsCmd());
                    for (List<String> jobIds : acquiredJobs.getJobIdBatches()) {
                        this.jobExecutor.executeJobs(jobIds);
                    }
                    this.millisToWait = this.jobExecutor.getWaitTimeInMillis();
                    int jobsAcquired = acquiredJobs.getJobIdBatches().size();
                    if (jobsAcquired < maxJobsPerAcquisition) {
                        long millisTillNextTimer;
                        this.isJobAdded = false;
                        Date duedate = new Date(ClockUtil.getCurrentTime().getTime() + this.millisToWait);
                        List<TimerEntity> nextTimers = commandExecutor.execute(new GetUnlockedTimersByDuedateCmd(duedate, new Page(0, 1)));
                        if (!nextTimers.isEmpty() && (millisTillNextTimer = nextTimers.get(0).getDuedate().getTime() - ClockUtil.getCurrentTime().getTime()) < this.millisToWait) {
                            this.millisToWait = millisTillNextTimer;
                        }
                    } else {
                        this.millisToWait = 0L;
                    }
                }
                catch (ActivitiOptimisticLockingException optimisticLockingException) {
                    if (log.isDebugEnabled()) {
                        log.debug("Optimistic locking exception during job acquisition. If you have multiple job executors running against the same database, this exception means that this thread tried to acquire a job, which already was acquired by another job executor acquisition thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple job executor acquisition threads running against the same database. Exception message: {}", (Object)optimisticLockingException.getMessage());
                    }
                }
                catch (Exception e) {
                    log.error("exception during job acquisition: {}", (Object)e.getMessage(), (Object)e);
                    this.millisToWait = (long)((float)this.millisToWait * this.waitIncreaseFactor);
                    if (this.millisToWait > this.maxWait) {
                        this.millisToWait = this.maxWait;
                    }
                    if (this.millisToWait != 0L) break block20;
                    this.millisToWait = this.jobExecutor.getWaitTimeInMillis();
                }
            }
            if (this.millisToWait <= 0L || this.isJobAdded) continue;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("job acquisition thread sleeping for {} millis", (Object)this.millisToWait);
                }
                Object e = this.MONITOR;
                synchronized (e) {
                    if (!this.isInterrupted) {
                        this.isWaiting.set(true);
                        this.MONITOR.wait(this.millisToWait);
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("job acquisition thread woke up");
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("job acquisition wait interrupted");
            }
            finally {
                this.isWaiting.set(false);
            }
        }
        log.info("{} stopped job acquisition", (Object)this.jobExecutor.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasAdded() {
        this.isJobAdded = true;
        if (this.isWaiting.compareAndSet(true, false)) {
            Object object = this.MONITOR;
            synchronized (object) {
                this.MONITOR.notifyAll();
            }
        }
    }

    public long getMillisToWait() {
        return this.millisToWait;
    }

    public void setMillisToWait(long millisToWait) {
        this.millisToWait = millisToWait;
    }

    public float getWaitIncreaseFactor() {
        return this.waitIncreaseFactor;
    }

    public void setWaitIncreaseFactor(float waitIncreaseFactor) {
        this.waitIncreaseFactor = waitIncreaseFactor;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }
}

