/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.component;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;

public class TraxErrorListener
implements ErrorListener {
    private TransformerException exception;
    private final Log log;
    private String uri;
    private TransformerException warningEx;

    public TraxErrorListener(Log log, String uri) {
        this.log = log;
        this.uri = uri;
    }

    public void error(TransformerException ex) throws TransformerException {
        if (this.warningEx != null && ex.getCause() == null) {
            ex = this.warningEx;
        }
        this.warningEx = null;
        this.exception = ex;
        throw ex;
    }

    public void fatalError(TransformerException ex) throws TransformerException {
        if (this.warningEx != null && ex.getCause() == null) {
            ex = this.warningEx;
        }
        this.warningEx = null;
        this.exception = ex;
        throw ex;
    }

    public Throwable getThrowable() {
        if (this.exception == null) {
            return null;
        }
        if (this.exception.getCause() != null) {
            return this.exception.getCause();
        }
        return this.exception;
    }

    public void warning(TransformerException ex) throws TransformerException {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)(ex.getMessage() + " at " + this.uri));
        }
        this.warningEx = ex;
    }
}

