/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipInputStream;
import javax.sql.DataSource;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.activiti.engine.impl.interceptor.CommandContextInterceptor;
import org.activiti.engine.impl.interceptor.CommandInterceptor;
import org.activiti.engine.impl.interceptor.LogInterceptor;
import org.activiti.engine.impl.variable.EntityManagerSession;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.spring.SpringEntityManagerSessionFactory;
import org.activiti.spring.SpringTransactionContextFactory;
import org.activiti.spring.SpringTransactionInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringProcessEngineConfiguration
extends ProcessEngineConfigurationImpl
implements ApplicationContextAware {
    protected PlatformTransactionManager transactionManager;
    protected String deploymentName = "SpringAutoDeployment";
    protected Resource[] deploymentResources = new Resource[0];
    protected ApplicationContext applicationContext;

    public SpringProcessEngineConfiguration() {
        this.transactionsExternallyManaged = true;
    }

    public ProcessEngine buildProcessEngine() {
        ProcessEngine processEngine = super.buildProcessEngine();
        this.autoDeployResources(processEngine);
        return processEngine;
    }

    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequired() {
        if (this.transactionManager == null) {
            throw new ActivitiException("transactionManager is required property for SpringProcessEngineConfiguration, use " + StandaloneProcessEngineConfiguration.class.getName() + " otherwise");
        }
        ArrayList<Object> defaultCommandInterceptorsTxRequired = new ArrayList<Object>();
        defaultCommandInterceptorsTxRequired.add(new LogInterceptor());
        defaultCommandInterceptorsTxRequired.add((Object)new SpringTransactionInterceptor(this.transactionManager, 0));
        CommandContextInterceptor commandContextInterceptor = new CommandContextInterceptor(this.commandContextFactory, (ProcessEngineConfigurationImpl)this);
        commandContextInterceptor.setContextReusePossible(true);
        defaultCommandInterceptorsTxRequired.add(commandContextInterceptor);
        return defaultCommandInterceptorsTxRequired;
    }

    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequiresNew() {
        ArrayList<Object> defaultCommandInterceptorsTxRequiresNew = new ArrayList<Object>();
        defaultCommandInterceptorsTxRequiresNew.add(new LogInterceptor());
        defaultCommandInterceptorsTxRequiresNew.add((Object)new SpringTransactionInterceptor(this.transactionManager, 3));
        CommandContextInterceptor commandContextInterceptor = new CommandContextInterceptor(this.commandContextFactory, (ProcessEngineConfigurationImpl)this);
        commandContextInterceptor.setContextReusePossible(false);
        defaultCommandInterceptorsTxRequiresNew.add(commandContextInterceptor);
        return defaultCommandInterceptorsTxRequiresNew;
    }

    protected void initTransactionContextFactory() {
        if (this.transactionContextFactory == null && this.transactionManager != null) {
            this.transactionContextFactory = new SpringTransactionContextFactory(this.transactionManager);
        }
    }

    protected void initJpa() {
        super.initJpa();
        if (this.jpaEntityManagerFactory != null) {
            this.sessionFactories.put(EntityManagerSession.class, new SpringEntityManagerSessionFactory(this.jpaEntityManagerFactory, this.jpaHandleTransaction, this.jpaCloseEntityManager));
        }
    }

    protected void autoDeployResources(ProcessEngine processEngine) {
        if (this.deploymentResources != null && this.deploymentResources.length > 0) {
            RepositoryService repositoryService = processEngine.getRepositoryService();
            DeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(this.deploymentName);
            for (Resource resource : this.deploymentResources) {
                String resourceName = null;
                if (resource instanceof ContextResource) {
                    resourceName = ((ContextResource)resource).getPathWithinContext();
                } else if (resource instanceof ByteArrayResource) {
                    resourceName = resource.getDescription();
                } else {
                    try {
                        resourceName = resource.getFile().getAbsolutePath();
                    }
                    catch (IOException e) {
                        resourceName = resource.getFilename();
                    }
                }
                try {
                    if (resourceName.endsWith(".bar") || resourceName.endsWith(".zip") || resourceName.endsWith(".jar")) {
                        deploymentBuilder.addZipInputStream(new ZipInputStream(resource.getInputStream()));
                        continue;
                    }
                    deploymentBuilder.addInputStream(resourceName, resource.getInputStream());
                }
                catch (IOException e) {
                    throw new ActivitiException("couldn't auto deploy resource '" + resource + "': " + e.getMessage(), (Throwable)e);
                }
            }
            deploymentBuilder.deploy();
        }
    }

    public ProcessEngineConfigurationImpl setDataSource(DataSource dataSource) {
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            return super.setDataSource(dataSource);
        }
        TransactionAwareDataSourceProxy proxiedDataSource = new TransactionAwareDataSourceProxy(dataSource);
        return super.setDataSource((DataSource)proxiedDataSource);
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public Resource[] getDeploymentResources() {
        return this.deploymentResources;
    }

    public void setDeploymentResources(Resource[] deploymentResources) {
        this.deploymentResources = deploymentResources;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

