/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings.def;

import java.lang.ref.WeakReference;
import org.apache.wicket.Page;
import org.apache.wicket.application.DefaultClassResolver;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.feedback.DefaultCleanupFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.settings.IApplicationSettings;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;

public class ApplicationSettings
implements IApplicationSettings {
    private WeakReference<Class<? extends Page>> accessDeniedPage;
    private IClassResolver classResolver = new DefaultClassResolver();
    private WeakReference<Class<? extends Page>> internalErrorPage;
    private WeakReference<Class<? extends Page>> pageExpiredErrorPage;
    private Bytes defaultMaximumUploadSize = Bytes.MAX;
    private boolean uploadProgressUpdatesEnabled = false;
    private IFeedbackMessageFilter feedbackMessageCleanupFilter = new DefaultCleanupFeedbackMessageFilter();

    @Override
    public Class<? extends Page> getAccessDeniedPage() {
        return (Class)this.accessDeniedPage.get();
    }

    @Override
    public IClassResolver getClassResolver() {
        return this.classResolver;
    }

    @Override
    public Bytes getDefaultMaximumUploadSize() {
        return this.defaultMaximumUploadSize;
    }

    @Override
    public Class<? extends Page> getInternalErrorPage() {
        return (Class)this.internalErrorPage.get();
    }

    @Override
    public Class<? extends Page> getPageExpiredErrorPage() {
        return (Class)this.pageExpiredErrorPage.get();
    }

    @Override
    public boolean isUploadProgressUpdatesEnabled() {
        return this.uploadProgressUpdatesEnabled;
    }

    @Override
    public void setAccessDeniedPage(Class<? extends Page> accessDeniedPage) {
        if (accessDeniedPage == null) {
            throw new IllegalArgumentException("Argument accessDeniedPage may not be null");
        }
        this.checkPageClass(accessDeniedPage);
        this.accessDeniedPage = new WeakReference<Class<? extends Page>>(accessDeniedPage);
    }

    @Override
    public void setClassResolver(IClassResolver defaultClassResolver) {
        this.classResolver = defaultClassResolver;
    }

    @Override
    public void setDefaultMaximumUploadSize(Bytes defaultMaximumUploadSize) {
        this.defaultMaximumUploadSize = defaultMaximumUploadSize;
    }

    @Override
    public void setInternalErrorPage(Class<? extends Page> internalErrorPage) {
        if (internalErrorPage == null) {
            throw new IllegalArgumentException("Argument internalErrorPage may not be null");
        }
        this.checkPageClass(internalErrorPage);
        this.internalErrorPage = new WeakReference<Class<? extends Page>>(internalErrorPage);
    }

    @Override
    public void setPageExpiredErrorPage(Class<? extends Page> pageExpiredErrorPage) {
        if (pageExpiredErrorPage == null) {
            throw new IllegalArgumentException("Argument pageExpiredErrorPage may not be null");
        }
        this.checkPageClass(pageExpiredErrorPage);
        this.pageExpiredErrorPage = new WeakReference<Class<? extends Page>>(pageExpiredErrorPage);
    }

    @Override
    public void setUploadProgressUpdatesEnabled(boolean uploadProgressUpdatesEnabled) {
        this.uploadProgressUpdatesEnabled = uploadProgressUpdatesEnabled;
    }

    private <C extends Page> void checkPageClass(Class<C> pageClass) {
        if (!Page.class.isAssignableFrom(pageClass)) {
            throw new IllegalArgumentException("argument " + pageClass + " must be a subclass of Page");
        }
    }

    @Override
    public void setFeedbackMessageCleanupFilter(IFeedbackMessageFilter filter) {
        Args.notNull((Object)filter, (String)"filter");
        this.feedbackMessageCleanupFilter = filter;
    }

    @Override
    public IFeedbackMessageFilter getFeedbackMessageCleanupFilter() {
        return this.feedbackMessageCleanupFilter;
    }
}

