/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.servlet.ErrorAttributes;
import org.apache.wicket.protocol.http.servlet.ForwardAttributes;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequestImpl;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.IWritableRequestParameters;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.flow.AbortWithHttpErrorCodeException;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.string.PrependingStringBuffer;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.upload.FileItemFactory;
import org.apache.wicket.util.upload.FileUploadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletWebRequest
extends WebRequest {
    private static final Logger LOG = LoggerFactory.getLogger(ServletWebRequest.class);
    private final HttpServletRequest httpServletRequest;
    private final Url url;
    private final String filterPrefix;
    private final ErrorAttributes errorAttributes;
    private final ForwardAttributes forwardAttributes;
    private Map<String, List<StringValue>> postParameters = null;
    private final IRequestParameters postRequestParameters = new IWritableRequestParameters(){

        public void reset() {
            ServletWebRequest.this.getPostRequestParameters().clear();
        }

        public void setParameterValues(String key, List<StringValue> values) {
            ServletWebRequest.this.getPostRequestParameters().put(key, values);
        }

        public Set<String> getParameterNames() {
            return Collections.unmodifiableSet(ServletWebRequest.this.getPostRequestParameters().keySet());
        }

        public StringValue getParameterValue(String name) {
            List values = (List)ServletWebRequest.this.getPostRequestParameters().get(name);
            if (values == null || values.isEmpty()) {
                return StringValue.valueOf((String)null);
            }
            return (StringValue)values.iterator().next();
        }

        public List<StringValue> getParameterValues(String name) {
            List values = (List)ServletWebRequest.this.getPostRequestParameters().get(name);
            if (values != null) {
                values = Collections.unmodifiableList(values);
            }
            return values;
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(ServletWebRequest.class);

    public ServletWebRequest(HttpServletRequest httpServletRequest, String filterPrefix) {
        this(httpServletRequest, filterPrefix, null);
    }

    public ServletWebRequest(HttpServletRequest httpServletRequest, String filterPrefix, Url url) {
        Args.notNull((Object)httpServletRequest, (String)"httpServletRequest");
        Args.notNull((Object)filterPrefix, (String)"filterPrefix");
        this.httpServletRequest = httpServletRequest;
        this.errorAttributes = ErrorAttributes.of(httpServletRequest, filterPrefix);
        this.forwardAttributes = ForwardAttributes.of(httpServletRequest, filterPrefix);
        if (this.forwardAttributes != null || this.errorAttributes != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting filterPrefix('{}') to '' because there is either an error or a forward. {}, {}", new Object[]{filterPrefix, this.forwardAttributes, this.errorAttributes});
            }
            this.filterPrefix = "";
        } else {
            this.filterPrefix = filterPrefix;
        }
        this.url = url != null ? url : this.getContextRelativeUrl(httpServletRequest.getRequestURI(), filterPrefix);
    }

    public Url getClientUrl() {
        if (this.errorAttributes != null && !Strings.isEmpty((CharSequence)this.errorAttributes.getRequestUri())) {
            String problematicURI = Url.parse((CharSequence)this.errorAttributes.getRequestUri(), (Charset)this.getCharset()).toString();
            return this.getContextRelativeUrl(problematicURI, this.filterPrefix);
        }
        if (this.forwardAttributes != null && !Strings.isEmpty((CharSequence)this.forwardAttributes.getRequestUri())) {
            String forwardURI = Url.parse((CharSequence)this.forwardAttributes.getRequestUri(), (Charset)this.getCharset()).toString();
            return this.getContextRelativeUrl(forwardURI, this.filterPrefix);
        }
        if (!this.isAjax()) {
            return this.getContextRelativeUrl(this.httpServletRequest.getRequestURI(), this.filterPrefix);
        }
        String base = this.getHeader("Wicket-Ajax-BaseURL");
        if (base == null) {
            base = this.getRequestParameters().getParameterValue("wicket-ajax-baseurl").toString(null);
        }
        if (base == null) {
            throw new AbortWithHttpErrorCodeException(400, "Current ajax request is missing the base url header or parameter");
        }
        return this.setParameters(Url.parse((CharSequence)base, (Charset)this.getCharset()));
    }

    private Url setParameters(Url url) {
        url.setPort(Integer.valueOf(this.httpServletRequest.getServerPort()));
        url.setHost(this.httpServletRequest.getServerName());
        url.setProtocol(this.httpServletRequest.getScheme());
        return url;
    }

    private Url getContextRelativeUrl(String uri, String filterPrefix) {
        String query;
        if (filterPrefix.length() > 0 && !filterPrefix.endsWith("/")) {
            filterPrefix = filterPrefix + "/";
        }
        StringBuilder url = new StringBuilder();
        uri = Strings.stripJSessionId((String)uri);
        String contextPath = this.httpServletRequest.getContextPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Calculating context relative path from: context path '{}', filterPrefix '{}', uri '{}'", new Object[]{contextPath, filterPrefix, uri});
        }
        int start = contextPath.length() + filterPrefix.length() + 1;
        if (uri.length() > start) {
            url.append(uri.substring(start));
        }
        if (this.errorAttributes == null && !Strings.isEmpty((CharSequence)(query = this.httpServletRequest.getQueryString()))) {
            url.append('?');
            url.append(query);
        }
        return this.setParameters(Url.parse((CharSequence)url.toString(), (Charset)this.getCharset()));
    }

    public String getFilterPrefix() {
        return this.filterPrefix;
    }

    public List<Cookie> getCookies() {
        Cookie[] cookies = this.httpServletRequest.getCookies();
        List<Object> result = cookies == null ? Collections.emptyList() : Arrays.asList(cookies);
        return Collections.unmodifiableList(result);
    }

    public Locale getLocale() {
        return this.httpServletRequest.getLocale();
    }

    public Time getDateHeader(String name) {
        try {
            long value = this.httpServletRequest.getDateHeader(name);
            if (value == -1L) {
                return null;
            }
            return Time.millis((long)value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getHeader(String name) {
        return this.httpServletRequest.getHeader(name);
    }

    public List<String> getHeaders(String name) {
        ArrayList result = new ArrayList();
        Enumeration e = this.httpServletRequest.getHeaders(name);
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        return Collections.unmodifiableList(result);
    }

    private static boolean isMultiPart(ServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().contains("multipart");
    }

    protected Map<String, List<StringValue>> generatePostParameters() {
        HashMap<String, List<StringValue>> postParameters = new HashMap<String, List<StringValue>>();
        IRequestParameters queryParams = this.getQueryParameters();
        Map params = this.getContainerRequest().getParameterMap();
        for (Map.Entry param : params.entrySet()) {
            String name = (String)param.getKey();
            String[] values = (String[])param.getValue();
            if (name == null || values == null) continue;
            List queryValues = queryParams.getParameterValues(name);
            queryValues = queryValues == null ? Collections.emptyList() : new ArrayList(queryValues);
            ArrayList<StringValue> postValues = new ArrayList<StringValue>();
            for (String value : values) {
                StringValue val = StringValue.valueOf((String)value);
                if (queryValues.contains(val)) {
                    queryValues.remove(val);
                    continue;
                }
                postValues.add(val);
            }
            if (postValues.isEmpty()) continue;
            postParameters.put(name, postValues);
        }
        return postParameters;
    }

    private Map<String, List<StringValue>> getPostRequestParameters() {
        if (this.postParameters == null) {
            this.postParameters = this.generatePostParameters();
        }
        return this.postParameters;
    }

    public IRequestParameters getPostParameters() {
        return this.postRequestParameters;
    }

    public Url getUrl() {
        return new Url(this.url);
    }

    public ServletWebRequest cloneWithUrl(Url url) {
        return new ServletWebRequest(this.httpServletRequest, this.filterPrefix, url){

            public Url getOriginalUrl() {
                return ServletWebRequest.this.getOriginalUrl();
            }

            @Override
            public IRequestParameters getPostParameters() {
                return ServletWebRequest.this.getPostParameters();
            }
        };
    }

    public MultipartServletWebRequest newMultipartWebRequest(Bytes maxSize, String upload) throws FileUploadException {
        return new MultipartServletWebRequestImpl(this.getContainerRequest(), this.filterPrefix, maxSize, upload);
    }

    public MultipartServletWebRequest newMultipartWebRequest(Bytes maxSize, String upload, FileItemFactory factory) throws FileUploadException {
        return new MultipartServletWebRequestImpl(this.getContainerRequest(), this.filterPrefix, maxSize, upload, factory);
    }

    public String getPrefixToContextPath() {
        PrependingStringBuffer buffer = new PrependingStringBuffer();
        Url filterPrefixUrl = Url.parse((CharSequence)this.filterPrefix, (Charset)this.getCharset());
        for (int i = 0; i < filterPrefixUrl.getSegments().size() - 1; ++i) {
            buffer.prepend("../");
        }
        return buffer.toString();
    }

    public Charset getCharset() {
        return RequestUtils.getCharset(this.httpServletRequest);
    }

    public HttpServletRequest getContainerRequest() {
        return this.httpServletRequest;
    }

    public String getContextPath() {
        return UrlUtils.normalizePath((String)this.httpServletRequest.getContextPath());
    }

    public String getFilterPath() {
        return UrlUtils.normalizePath((String)this.filterPrefix);
    }

    public boolean shouldPreserveClientUrl() {
        return this.errorAttributes != null && !Strings.isEmpty((CharSequence)this.errorAttributes.getRequestUri()) || this.forwardAttributes != null && !Strings.isEmpty((CharSequence)this.forwardAttributes.getRequestUri());
    }
}

