/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.renderStrategy;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.renderStrategy.AbstractHeaderRenderStrategy;
import org.apache.wicket.markup.renderStrategy.DeepChildFirstVisitor;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.visit.IVisit;

public class ChildFirstHeaderRenderStrategy
extends AbstractHeaderRenderStrategy {
    @Override
    public void renderHeader(HtmlHeaderContainer headerContainer, HtmlHeaderContainer.HeaderStreamState headerStreamState, Component rootComponent) {
        Args.notNull((Object)headerContainer, (String)"headerContainer");
        Args.notNull((Object)rootComponent, (String)"rootComponent");
        this.renderApplicationLevelHeaders(headerContainer);
        this.renderChildHeaders(headerContainer, rootComponent);
        this.renderRootComponent(headerContainer, headerStreamState, rootComponent);
    }

    @Override
    protected void renderChildHeaders(final HtmlHeaderContainer headerContainer, final Component rootComponent) {
        Args.notNull((Object)headerContainer, (String)"headerContainer");
        Args.notNull((Object)rootComponent, (String)"rootComponent");
        if (rootComponent instanceof MarkupContainer) {
            new DeepChildFirstVisitor(){

                @Override
                public void component(Component component, IVisit<Void> visit) {
                    if (component != rootComponent) {
                        component.renderHead(headerContainer);
                    }
                }

                @Override
                public boolean preCheck(Component component) {
                    return component.isVisibleInHierarchy();
                }
            }.visit(rootComponent);
        }
    }
}

