/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.cocoon.pipeline.NonCachingPipeline;
import org.apache.cocoon.pipeline.component.PipelineComponent;
import org.apache.cocoon.sax.component.XMLGenerator;
import org.apache.cocoon.sax.component.XMLSerializer;
import org.apache.cocoon.sax.component.XSLTTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransformationUtils {
    public static String transform(String xmlString, URL ... xsltUrls) throws Exception {
        return TransformationUtils.transform(xmlString, (Map<String, Object>)null, (Properties)null, xsltUrls);
    }

    public static String transform(String xmlString, Map<String, Object> xsltParameters, URL ... xsltUrls) throws Exception {
        return TransformationUtils.transform(xmlString, xsltParameters, (Properties)null, xsltUrls);
    }

    public static String transform(String xmlString, Properties outputProperties, URL ... xsltUrls) throws Exception {
        return TransformationUtils.transform(xmlString, (Map<String, Object>)null, outputProperties, xsltUrls);
    }

    public static String transform(String xmlString, Map<String, Object> xsltParameters, Properties outputProperties, URL ... xsltUrls) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TransformationUtils.transform(xmlString, xsltParameters, outputProperties, byteArrayOutputStream, xsltUrls);
        return new String(byteArrayOutputStream.toByteArray());
    }

    public static void transform(String xmlString, OutputStream outputStream, URL ... xsltURLs) throws Exception {
        TransformationUtils.transform(xmlString, (Map<String, Object>)null, (Properties)null, outputStream, xsltURLs);
    }

    public static void transform(String xmlString, OutputStream outputStream, Map<String, Object> xsltParameters, URL ... xsltURLs) throws Exception {
        TransformationUtils.transform(xmlString, xsltParameters, (Properties)null, outputStream, xsltURLs);
    }

    public static void transform(String xmlString, OutputStream outputStream, Properties outputProperties, URL ... xsltURLs) throws Exception {
        TransformationUtils.transform(xmlString, (Map<String, Object>)null, outputProperties, outputStream, xsltURLs);
    }

    public static void transform(String xmlString, Map<String, Object> xsltParameters, Properties outputProperties, OutputStream outputStream, URL ... xsltUrls) throws Exception {
        NonCachingPipeline pipeline = new NonCachingPipeline();
        pipeline.addComponent((PipelineComponent)new XMLGenerator(xmlString));
        for (URL xsltUrl : xsltUrls) {
            XSLTTransformer xsltTransformer = new XSLTTransformer(xsltUrl);
            xsltTransformer.setParameters(xsltParameters);
            pipeline.addComponent((PipelineComponent)xsltTransformer);
        }
        if (outputProperties == null) {
            outputProperties = new Properties();
        }
        pipeline.addComponent((PipelineComponent)new XMLSerializer(outputProperties));
        pipeline.setup(outputStream, null);
        pipeline.execute();
    }
}

