/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.component;

import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.SimpleCacheKey;
import org.apache.cocoon.pipeline.component.CachingPipelineComponent;
import org.apache.cocoon.sax.AbstractSAXTransformer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CleaningTransformer
extends AbstractSAXTransformer
implements CachingPipelineComponent {
    private static final String EMPTY_NS = "";
    private char[] characters = new char[8192];
    private int position;

    public void startPrefixMapping(String prefix, String uri) {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        this.maybeWriteCharacters();
        AttributesImpl noNamespaceAtts = new AttributesImpl();
        for (int i = 0; i < atts.getLength(); ++i) {
            String attrName = atts.getLocalName(i);
            String attrValue = atts.getValue(i);
            String attrType = atts.getType(i);
            if (attrValue == null) continue;
            noNamespaceAtts.addAttribute(EMPTY_NS, attrName, attrName, attrType, attrValue);
        }
        super.startElement(EMPTY_NS, localName, localName, atts);
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        this.maybeWriteCharacters();
        super.endElement(EMPTY_NS, localName, localName);
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        int remaining = this.characters.length - this.position;
        if (len > remaining) {
            int newCapacity = this.characters.length + len + 1000;
            char[] nextCharacters = new char[newCapacity];
            System.arraycopy(this.characters, 0, nextCharacters, 0, this.position);
            this.characters = nextCharacters;
        }
        System.arraycopy(c, start, this.characters, this.position, len);
        this.position += len;
    }

    private void maybeWriteCharacters() throws SAXException {
        if (this.position == 0) {
            return;
        }
        for (int i = 0; i < this.position; ++i) {
            char eachChar = this.characters[i];
            if (Character.isWhitespace(eachChar) && eachChar != '\u00a0') continue;
            super.characters(this.characters, 0, this.position);
            break;
        }
        this.position = 0;
    }

    public CacheKey constructCacheKey() {
        return new SimpleCacheKey();
    }
}

