/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.impl.HistoricVariableInstanceQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInstanceEntity;

public class HistoricVariableInstanceEntityManager
extends AbstractManager {
    public void deleteHistoricVariableInstanceByProcessInstanceId(String historicProcessInstanceId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            List historicProcessVariables = this.getDbSqlSession().createHistoricVariableInstanceQuery().processInstanceId(historicProcessInstanceId).list();
            for (HistoricVariableInstanceEntity historicProcessVariable : historicProcessVariables) {
                historicProcessVariable.delete();
            }
            List<HistoricVariableInstanceEntity> cachedHistoricVariableInstances = this.getDbSqlSession().findInCache(HistoricVariableInstanceEntity.class);
            for (HistoricVariableInstanceEntity historicProcessVariable : cachedHistoricVariableInstances) {
                if (!historicProcessVariable.getProcessInstanceId().equals(historicProcessInstanceId)) continue;
                historicProcessVariable.delete();
            }
        }
    }

    public long findHistoricVariableInstanceCountByQueryCriteria(HistoricVariableInstanceQueryImpl historicProcessVariableQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoricVariableInstanceCountByQueryCriteria", historicProcessVariableQuery);
    }

    public List<HistoricVariableInstance> findHistoricVariableInstancesByQueryCriteria(HistoricVariableInstanceQueryImpl historicProcessVariableQuery, Page page) {
        return this.getDbSqlSession().selectList("selectHistoricVariableInstanceByQueryCriteria", historicProcessVariableQuery, page);
    }

    public HistoricVariableInstanceEntity findHistoricVariableInstanceByVariableInstanceId(String variableInstanceId) {
        return (HistoricVariableInstanceEntity)this.getDbSqlSession().selectOne("selectHistoricVariableInstanceByVariableInstanceId", variableInstanceId);
    }

    public void deleteHistoricVariableInstancesByTaskId(String taskId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricVariableInstanceQueryImpl historicProcessVariableQuery = (HistoricVariableInstanceQueryImpl)new HistoricVariableInstanceQueryImpl().taskId(taskId);
            List historicProcessVariables = historicProcessVariableQuery.list();
            for (HistoricVariableInstance historicProcessVariable : historicProcessVariables) {
                ((HistoricVariableInstanceEntity)historicProcessVariable).delete();
            }
        }
    }
}

