/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.engine.impl.GroupQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.GroupEntity;

public class GroupEntityManager
extends AbstractManager {
    public Group createNewGroup(String groupId) {
        return new GroupEntity(groupId);
    }

    public void insertGroup(Group group) {
        this.getDbSqlSession().insert((PersistentObject)((Object)group));
    }

    public void updateGroup(GroupEntity updatedGroup) {
        CommandContext commandContext = Context.getCommandContext();
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        dbSqlSession.update(updatedGroup);
    }

    public void deleteGroup(String groupId) {
        GroupEntity group = this.getDbSqlSession().selectById(GroupEntity.class, groupId);
        this.getDbSqlSession().delete("deleteMembershipsByGroupId", groupId);
        this.getDbSqlSession().delete(group);
    }

    public GroupQuery createNewGroupQuery() {
        return new GroupQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    public List<Group> findGroupByQueryCriteria(GroupQueryImpl query, Page page) {
        return this.getDbSqlSession().selectList("selectGroupByQueryCriteria", query, page);
    }

    public long findGroupCountByQueryCriteria(GroupQueryImpl query) {
        return (Long)this.getDbSqlSession().selectOne("selectGroupCountByQueryCriteria", query);
    }

    public GroupEntity findGroupById(String groupId) {
        return (GroupEntity)this.getDbSqlSession().selectOne("selectGroupById", groupId);
    }

    public List<Group> findGroupsByUser(String userId) {
        return this.getDbSqlSession().selectList("selectGroupsByUserId", userId);
    }

    public List<Group> findPotentialStarterUsers(String proceDefId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("procDefId", proceDefId);
        return (List)this.getDbSqlSession().selectOne("selectGroupByQueryCriteria", parameters);
    }
}

