/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.util.List;
import org.activiti.engine.impl.cmd.ExecuteJobsCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.impl.jobexecutor.JobExecutorContext;

public class ExecuteJobsRunnable
implements Runnable {
    private final List<String> jobIds;
    private final JobExecutor jobExecutor;

    public ExecuteJobsRunnable(JobExecutor jobExecutor, List<String> jobIds) {
        this.jobExecutor = jobExecutor;
        this.jobIds = jobIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JobExecutorContext jobExecutorContext = new JobExecutorContext();
        List<String> currentProcessorJobQueue = jobExecutorContext.getCurrentProcessorJobQueue();
        CommandExecutor commandExecutor = this.jobExecutor.getCommandExecutor();
        currentProcessorJobQueue.addAll(this.jobIds);
        Context.setJobExecutorContext(jobExecutorContext);
        try {
            while (!currentProcessorJobQueue.isEmpty()) {
                commandExecutor.execute(new ExecuteJobsCmd(currentProcessorJobQueue.remove(0)));
            }
        }
        finally {
            Context.removeJobExecutorContext();
        }
    }
}

