/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;

public class DeleteTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Collection<String> taskIds;
    protected boolean cascade;
    protected String deleteReason;

    public DeleteTaskCmd(String taskId, String deleteReason, boolean cascade) {
        this.taskId = taskId;
        this.cascade = cascade;
        this.deleteReason = deleteReason;
    }

    public DeleteTaskCmd(Collection<String> taskIds, String deleteReason, boolean cascade) {
        this.taskIds = taskIds;
        this.cascade = cascade;
        this.deleteReason = deleteReason;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.taskId != null) {
            this.deleteTask(this.taskId);
        } else if (this.taskIds != null) {
            for (String taskId : this.taskIds) {
                this.deleteTask(taskId);
            }
        } else {
            throw new ActivitiIllegalArgumentException("taskId and taskIds are null");
        }
        return null;
    }

    protected void deleteTask(String taskId) {
        Context.getCommandContext().getTaskEntityManager().deleteTask(taskId, this.deleteReason, this.cascade);
    }
}

