/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.bpmn.behavior.EventBasedGatewayActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.IntermediateCatchEventActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractBpmnParseHandler;
import org.activiti.engine.impl.el.UelExpressionCondition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.apache.commons.lang.StringUtils;

public class SequenceFlowParseHandler
extends AbstractBpmnParseHandler<SequenceFlow> {
    public static final String PROPERTYNAME_CONDITION = "condition";
    public static final String PROPERTYNAME_CONDITION_TEXT = "conditionText";

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return SequenceFlow.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, SequenceFlow sequenceFlow) {
        BpmnModel bpmnModel = bpmnParse.getBpmnModel();
        ScopeImpl scope = bpmnParse.getCurrentScope();
        ActivityImpl sourceActivity = scope.findActivity(sequenceFlow.getSourceRef());
        ActivityImpl destinationActivity = scope.findActivity(sequenceFlow.getTargetRef());
        if (sourceActivity == null) {
            bpmnModel.addProblem("Invalid source '" + sequenceFlow.getSourceRef() + "' of sequence flow '" + sequenceFlow.getId() + "'", (BaseElement)sequenceFlow);
        } else {
            if (destinationActivity == null) {
                throw new ActivitiException("Invalid destination '" + sequenceFlow.getTargetRef() + "' of sequence flow '" + sequenceFlow.getId() + "'");
            }
            if (!(sourceActivity.getActivityBehavior() instanceof EventBasedGatewayActivityBehavior) && destinationActivity.getActivityBehavior() instanceof IntermediateCatchEventActivityBehavior && destinationActivity.getParentActivity() != null && destinationActivity.getParentActivity().getActivityBehavior() instanceof EventBasedGatewayActivityBehavior) {
                bpmnModel.addProblem("Invalid incoming sequenceflow " + sequenceFlow.getId() + " for intermediateCatchEvent with id '" + destinationActivity.getId() + "' connected to an event-based gateway.", (BaseElement)sequenceFlow);
            } else {
                TransitionImpl transition = sourceActivity.createOutgoingTransition(sequenceFlow.getId());
                bpmnParse.getSequenceFlows().put(sequenceFlow.getId(), transition);
                transition.setProperty("name", sequenceFlow.getName());
                transition.setProperty("documentation", sequenceFlow.getDocumentation());
                transition.setDestination(destinationActivity);
                if (StringUtils.isNotEmpty((String)sequenceFlow.getConditionExpression())) {
                    UelExpressionCondition expressionCondition = new UelExpressionCondition(bpmnParse.getExpressionManager().createExpression(sequenceFlow.getConditionExpression()));
                    transition.setProperty(PROPERTYNAME_CONDITION_TEXT, sequenceFlow.getConditionExpression());
                    transition.setProperty(PROPERTYNAME_CONDITION, expressionCondition);
                }
                this.createExecutionListenersOnTransition(bpmnParse, sequenceFlow.getExecutionListeners(), transition);
            }
        }
    }
}

