/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.DataAssociation;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.SendTask;
import org.activiti.bpmn.model.Task;
import org.activiti.engine.impl.bpmn.behavior.WebServiceActivityBehavior;
import org.activiti.engine.impl.bpmn.data.AbstractDataAssociation;
import org.activiti.engine.impl.bpmn.data.IOSpecification;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractExternalInvocationBpmnParseHandler;
import org.activiti.engine.impl.bpmn.webservice.Operation;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.apache.commons.lang.StringUtils;

public class SendTaskParseHandler
extends AbstractExternalInvocationBpmnParseHandler<SendTask> {
    @Override
    public Class<? extends BaseElement> getHandledType() {
        return SendTask.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, SendTask sendTask) {
        ActivityImpl activity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)sendTask, "sendTask");
        activity.setAsync(sendTask.isAsynchronous());
        activity.setExclusive(!sendTask.isNotExclusive());
        if (StringUtils.isNotEmpty((String)sendTask.getType())) {
            if (sendTask.getType().equalsIgnoreCase("mail")) {
                this.validateFieldDeclarationsForEmail(bpmnParse, (Task)sendTask, sendTask.getFieldExtensions());
                activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createMailActivityBehavior(sendTask));
            } else if (sendTask.getType().equalsIgnoreCase("mule")) {
                activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createMuleActivityBehavior(sendTask, bpmnParse.getBpmnModel()));
            } else if (sendTask.getType().equalsIgnoreCase("camel")) {
                activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createCamelActivityBehavior(sendTask, bpmnParse.getBpmnModel()));
            } else {
                bpmnParse.getBpmnModel().addProblem("Invalid usage of type attribute: '" + sendTask.getType() + "'.", (BaseElement)sendTask);
            }
        } else if (ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE.equalsIgnoreCase(sendTask.getImplementationType()) && StringUtils.isNotEmpty((String)sendTask.getOperationRef())) {
            if (!bpmnParse.getOperations().containsKey(sendTask.getOperationRef())) {
                bpmnParse.getBpmnModel().addProblem(sendTask.getOperationRef() + " does not exist", (BaseElement)sendTask);
            } else {
                AbstractDataAssociation dataAssociation;
                WebServiceActivityBehavior webServiceActivityBehavior = bpmnParse.getActivityBehaviorFactory().createWebServiceActivityBehavior(sendTask);
                Operation operation = bpmnParse.getOperations().get(sendTask.getOperationRef());
                webServiceActivityBehavior.setOperation(operation);
                if (sendTask.getIoSpecification() != null) {
                    IOSpecification ioSpecification = this.createIOSpecification(bpmnParse, sendTask.getIoSpecification());
                    webServiceActivityBehavior.setIoSpecification(ioSpecification);
                }
                for (DataAssociation dataAssociationElement : sendTask.getDataInputAssociations()) {
                    dataAssociation = this.createDataInputAssociation(bpmnParse, dataAssociationElement);
                    webServiceActivityBehavior.addDataInputAssociation(dataAssociation);
                }
                for (DataAssociation dataAssociationElement : sendTask.getDataOutputAssociations()) {
                    dataAssociation = this.createDataOutputAssociation(bpmnParse, dataAssociationElement);
                    webServiceActivityBehavior.addDataOutputAssociation(dataAssociation);
                }
                activity.setActivityBehavior(webServiceActivityBehavior);
            }
        } else {
            bpmnParse.getBpmnModel().addProblem("One of the attributes 'type' or 'operation' is mandatory on sendTask.", (BaseElement)sendTask);
        }
    }
}

