/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.CompensateEventDefinition;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.apache.commons.lang.StringUtils;

public class CompensateEventDefinitionParseHandler
extends AbstractBpmnParseHandler<org.activiti.bpmn.model.CompensateEventDefinition> {
    @Override
    public Class<? extends BaseElement> getHandledType() {
        return org.activiti.bpmn.model.CompensateEventDefinition.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, org.activiti.bpmn.model.CompensateEventDefinition eventDefinition) {
        ScopeImpl scope = bpmnParse.getCurrentScope();
        if (StringUtils.isNotEmpty((String)eventDefinition.getActivityRef()) && scope.findActivity(eventDefinition.getActivityRef()) == null) {
            bpmnParse.getBpmnModel().addProblem("Invalid attribute value for 'activityRef': no activity with id '" + eventDefinition.getActivityRef() + "' in current scope " + scope.getId(), (BaseElement)eventDefinition);
        }
        CompensateEventDefinition compensateEventDefinition = new CompensateEventDefinition();
        compensateEventDefinition.setActivityRef(eventDefinition.getActivityRef());
        compensateEventDefinition.setWaitForCompletion(eventDefinition.isWaitForCompletion());
        ActivityImpl activity = bpmnParse.getCurrentActivity();
        if (bpmnParse.getCurrentFlowElement() instanceof ThrowEvent) {
            activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createIntermediateThrowCompensationEventActivityBehavior((ThrowEvent)bpmnParse.getCurrentFlowElement(), compensateEventDefinition));
        } else if (bpmnParse.getCurrentFlowElement() instanceof BoundaryEvent) {
            BoundaryEvent boundaryEvent = (BoundaryEvent)bpmnParse.getCurrentFlowElement();
            boolean interrupting = boundaryEvent.isCancelActivity();
            activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createBoundaryEventActivityBehavior(boundaryEvent, interrupting, activity));
            activity.setProperty("type", "compensationBoundaryCatch");
            ScopeImpl parent = activity.getParent();
            for (ActivityImpl child : parent.getActivities()) {
                if (!child.getProperty("type").equals("compensationBoundaryCatch") || child == activity) continue;
                bpmnParse.getBpmnModel().addProblem("multiple boundary events with compensateEventDefinition not supported on same activity.", (BaseElement)eventDefinition);
            }
        }
    }
}

