/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractFlowNodeBpmnParseHandler;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractActivityBpmnParseHandler<T extends FlowNode>
extends AbstractFlowNodeBpmnParseHandler<T> {
    @Override
    public void parse(BpmnParse bpmnParse, BaseElement element) {
        super.parse(bpmnParse, element);
        if (element instanceof Activity && ((Activity)element).getLoopCharacteristics() != null) {
            this.createMultiInstanceLoopCharacteristics(bpmnParse, (Activity)element);
        }
    }

    protected void createMultiInstanceLoopCharacteristics(BpmnParse bpmnParse, Activity modelActivity) {
        MultiInstanceLoopCharacteristics loopCharacteristics = modelActivity.getLoopCharacteristics();
        MultiInstanceActivityBehavior miActivityBehavior = null;
        ActivityImpl activity = bpmnParse.getCurrentScope().findActivity(modelActivity.getId());
        if (activity == null) {
            bpmnParse.getBpmnModel().addProblem("Activity " + modelActivity.getId() + " needed for multi instance cannot bv found", (BaseElement)modelActivity);
        }
        miActivityBehavior = loopCharacteristics.isSequential() ? bpmnParse.getActivityBehaviorFactory().createSequentialMultiInstanceBehavior(activity, (AbstractBpmnActivityBehavior)activity.getActivityBehavior()) : bpmnParse.getActivityBehaviorFactory().createParallelMultiInstanceBehavior(activity, (AbstractBpmnActivityBehavior)activity.getActivityBehavior());
        activity.setScope(true);
        activity.setProperty("multiInstance", loopCharacteristics.isSequential() ? "sequential" : "parallel");
        activity.setActivityBehavior(miActivityBehavior);
        ExpressionManager expressionManager = bpmnParse.getExpressionManager();
        BpmnModel bpmnModel = bpmnParse.getBpmnModel();
        if (StringUtils.isNotEmpty((String)loopCharacteristics.getLoopCardinality())) {
            miActivityBehavior.setLoopCardinalityExpression(expressionManager.createExpression(loopCharacteristics.getLoopCardinality()));
        }
        if (StringUtils.isNotEmpty((String)loopCharacteristics.getCompletionCondition())) {
            miActivityBehavior.setCompletionConditionExpression(expressionManager.createExpression(loopCharacteristics.getCompletionCondition()));
        }
        if (StringUtils.isNotEmpty((String)loopCharacteristics.getInputDataItem())) {
            if (loopCharacteristics.getInputDataItem().contains("{")) {
                miActivityBehavior.setCollectionExpression(expressionManager.createExpression(loopCharacteristics.getInputDataItem()));
            } else {
                miActivityBehavior.setCollectionVariable(loopCharacteristics.getInputDataItem());
            }
        }
        if (StringUtils.isNotEmpty((String)loopCharacteristics.getElementVariable())) {
            miActivityBehavior.setCollectionElementVariable(loopCharacteristics.getElementVariable());
        }
        if (miActivityBehavior.getLoopCardinalityExpression() == null && miActivityBehavior.getCollectionExpression() == null && miActivityBehavior.getCollectionVariable() == null) {
            bpmnModel.addProblem("Either loopCardinality or loopDataInputRef/activiti:collection must been set.", (BaseElement)loopCharacteristics);
        }
        if (miActivityBehavior.getCollectionExpression() == null && miActivityBehavior.getCollectionVariable() == null && miActivityBehavior.getCollectionElementVariable() != null) {
            bpmnModel.addProblem("LoopDataInputRef/activiti:collection must be set when using inputDataItem or activiti:elementVariable.", (BaseElement)loopCharacteristics);
        }
    }
}

