/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.pvm.PvmProcessDefinition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.rules.RulesAgendaFilter;
import org.activiti.engine.impl.rules.RulesHelper;
import org.drools.KnowledgeBase;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.AgendaFilter;

public class BusinessRuleTaskActivityBehavior
extends TaskActivityBehavior {
    protected Set<Expression> variablesInputExpressions = new HashSet<Expression>();
    protected Set<Expression> rulesExpressions = new HashSet<Expression>();
    protected boolean exclude = false;
    protected String resultVariable;

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        PvmProcessDefinition processDefinition = execution.getActivity().getProcessDefinition();
        String deploymentId = processDefinition.getDeploymentId();
        KnowledgeBase knowledgeBase = RulesHelper.findKnowledgeBaseByDeploymentId(deploymentId);
        StatefulKnowledgeSession ksession = knowledgeBase.newStatefulKnowledgeSession();
        if (this.variablesInputExpressions != null) {
            for (Expression variable : this.variablesInputExpressions) {
                ksession.insert(variable.getValue(execution));
            }
        }
        if (this.rulesExpressions.size() > 0) {
            RulesAgendaFilter filter = new RulesAgendaFilter();
            for (Expression ruleName : this.rulesExpressions) {
                filter.addSuffic(ruleName.getValue(execution).toString());
            }
            filter.setAccept(!this.exclude);
            ksession.fireAllRules((AgendaFilter)filter);
        } else {
            ksession.fireAllRules();
        }
        Collection ruleOutputObjects = ksession.getObjects();
        if (ruleOutputObjects != null && ruleOutputObjects.size() > 0) {
            ArrayList outputVariables = new ArrayList();
            for (Object object : ruleOutputObjects) {
                outputVariables.add(object);
            }
            execution.setVariable(this.resultVariable, outputVariables);
        }
        ksession.dispose();
        this.leave(execution);
    }

    public void addRuleVariableInputIdExpression(Expression inputId) {
        this.variablesInputExpressions.add(inputId);
    }

    public void addRuleIdExpression(Expression inputId) {
        this.rulesExpressions.add(inputId);
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public void setResultVariable(String resultVariableName) {
        this.resultVariable = resultVariableName;
    }
}

