/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.client.ClientException;
import javax.ws.rs.client.InvocationCallback;
import org.apache.cxf.endpoint.ClientCallback;

class JaxrsClientCallback<T>
extends ClientCallback {
    private final InvocationCallback<T> handler;
    private final Type outType;
    private final Class<?> responseClass;

    public JaxrsClientCallback(InvocationCallback<T> handler, Class<?> responseClass, Type outGenericType) {
        this.handler = handler;
        this.outType = outGenericType;
        this.responseClass = responseClass;
    }

    public Type getOutGenericType() {
        return this.outType;
    }

    public Class<?> getResponseClass() {
        return this.responseClass;
    }

    public Future<T> createFuture() {
        return new JaxrsResponseCallback(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResponse(Map<String, Object> ctx, Object[] res) {
        this.context = ctx;
        this.result = res;
        if (this.handler != null) {
            this.handler.completed(res[0]);
        }
        this.done = true;
        JaxrsClientCallback jaxrsClientCallback = this;
        synchronized (jaxrsClientCallback) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(Map<String, Object> ctx, Throwable ex) {
        this.context = ctx;
        this.exception = ex instanceof ClientException ? ex : new ClientException(ex);
        if (this.handler != null) {
            this.handler.failed((ClientException)this.exception);
        }
        this.done = true;
        JaxrsClientCallback jaxrsClientCallback = this;
        synchronized (jaxrsClientCallback) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    static class JaxrsResponseCallback<T>
    implements Future<T> {
        JaxrsClientCallback<T> callback;

        public JaxrsResponseCallback(JaxrsClientCallback<T> cb) {
            this.callback = cb;
        }

        public Map<String, Object> getContext() {
            try {
                return this.callback.getResponseContext();
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.callback.cancel(mayInterruptIfRunning);
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return (T)this.callback.get()[0];
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (T)this.callback.get(timeout, unit)[0];
        }

        @Override
        public boolean isCancelled() {
            return this.callback.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.callback.isDone();
        }
    }
}

