/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.syncope.common.to.CorrelationRuleClassTO;
import org.apache.syncope.common.to.EntitlementTO;
import org.apache.syncope.common.to.JobClassTO;
import org.apache.syncope.common.to.LoggerTO;
import org.apache.syncope.common.to.MailTemplateTO;
import org.apache.syncope.common.to.PropagationActionClassTO;
import org.apache.syncope.common.to.SyncActionClassTO;
import org.apache.syncope.common.to.ValidatorTO;
import org.apache.syncope.common.types.AuditLoggerName;
import org.apache.syncope.common.types.SyncopeLoggerLevel;
import org.springframework.web.servlet.ModelAndView;

public final class CollectionWrapper {
    private CollectionWrapper() {
    }

    public static List<String> wrapStrings(ModelAndView modelAndView) {
        return (List)modelAndView.getModel().values().iterator().next();
    }

    public static Set<EntitlementTO> wrap(Collection<String> collection) {
        HashSet<EntitlementTO> respons = new HashSet<EntitlementTO>();
        for (String e : collection) {
            respons.add(EntitlementTO.instance(e));
        }
        return respons;
    }

    public static Set<String> unwrap(Collection<EntitlementTO> collection) {
        HashSet<String> respons = new HashSet<String>();
        for (EntitlementTO e : collection) {
            respons.add(e.getName());
        }
        return respons;
    }

    public static Set<MailTemplateTO> wrapMailTemplates(Collection<String> collection) {
        HashSet<MailTemplateTO> respons = new HashSet<MailTemplateTO>();
        for (String e : collection) {
            respons.add(MailTemplateTO.instance(e));
        }
        return respons;
    }

    public static List<String> unwrapMailTemplates(Collection<MailTemplateTO> collection) {
        ArrayList<String> respons = new ArrayList<String>();
        for (MailTemplateTO e : collection) {
            respons.add(e.getName());
        }
        return respons;
    }

    public static Set<ValidatorTO> wrapValidators(Collection<String> validators) {
        HashSet<ValidatorTO> respons = new HashSet<ValidatorTO>();
        for (String validator : validators) {
            respons.add(ValidatorTO.instance(validator));
        }
        return respons;
    }

    public static List<String> unwrapValidator(Collection<ValidatorTO> collection) {
        ArrayList<String> respons = new ArrayList<String>();
        for (ValidatorTO e : collection) {
            respons.add(e.getName());
        }
        return respons;
    }

    public static List<AuditLoggerName> wrapLogger(Collection<LoggerTO> logger) {
        ArrayList<AuditLoggerName> respons = new ArrayList<AuditLoggerName>();
        for (LoggerTO l : logger) {
            try {
                respons.add(AuditLoggerName.fromLoggerName(l.getName()));
            }
            catch (Exception e) {}
        }
        return respons;
    }

    public static List<LoggerTO> unwrapLogger(Collection<AuditLoggerName> auditNames) {
        ArrayList<LoggerTO> respons = new ArrayList<LoggerTO>();
        for (AuditLoggerName l : auditNames) {
            LoggerTO loggerTO = new LoggerTO();
            loggerTO.setName(l.toLoggerName());
            loggerTO.setLevel(SyncopeLoggerLevel.DEBUG);
            respons.add(loggerTO);
        }
        return respons;
    }

    public static Set<JobClassTO> wrapJobClasses(Collection<String> classes) {
        HashSet<JobClassTO> respons = new HashSet<JobClassTO>();
        for (String cl : classes) {
            respons.add(JobClassTO.instance(cl));
        }
        return respons;
    }

    public static List<String> unwrapJobClasses(Collection<JobClassTO> jobClasses) {
        ArrayList<String> respons = new ArrayList<String>();
        for (JobClassTO e : jobClasses) {
            respons.add(e.getName());
        }
        return respons;
    }

    public static Set<SyncActionClassTO> wrapSyncActionClasses(Collection<String> classes) {
        HashSet<SyncActionClassTO> respons = new HashSet<SyncActionClassTO>();
        for (String cl : classes) {
            respons.add(SyncActionClassTO.instance(cl));
        }
        return respons;
    }

    public static List<String> unwrapSyncActionClasses(Collection<SyncActionClassTO> actions) {
        ArrayList<String> respons = new ArrayList<String>();
        for (SyncActionClassTO e : actions) {
            respons.add(e.getName());
        }
        return respons;
    }

    public static Set<PropagationActionClassTO> wrapPropagationActionClasses(Collection<String> classes) {
        HashSet<PropagationActionClassTO> respons = new HashSet<PropagationActionClassTO>();
        for (String cl : classes) {
            respons.add(PropagationActionClassTO.instance(cl));
        }
        return respons;
    }

    public static List<String> unwrapPropagationActionClasses(Collection<PropagationActionClassTO> actions) {
        ArrayList<String> respons = new ArrayList<String>();
        for (PropagationActionClassTO e : actions) {
            respons.add(e.getName());
        }
        return respons;
    }

    public static Set<CorrelationRuleClassTO> wrapSyncCorrelationRuleClasses(Collection<String> classes) {
        HashSet<CorrelationRuleClassTO> respons = new HashSet<CorrelationRuleClassTO>();
        for (String cl : classes) {
            respons.add(CorrelationRuleClassTO.instance(cl));
        }
        return respons;
    }

    public static List<String> unwrapSyncCorrelationRuleClasses(Collection<CorrelationRuleClassTO> actions) {
        ArrayList<String> respons = new ArrayList<String>();
        for (CorrelationRuleClassTO e : actions) {
            respons.add(e.getName());
        }
        return respons;
    }
}

