/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.services.proxy;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.services.proxy.SpringServiceProxy;
import org.apache.syncope.common.mod.RoleMod;
import org.apache.syncope.common.search.NodeCond;
import org.apache.syncope.common.services.RoleService;
import org.apache.syncope.common.to.RoleTO;
import org.springframework.web.client.RestTemplate;

public class RoleServiceProxy
extends SpringServiceProxy
implements RoleService {
    public RoleServiceProxy(String baseUrl, RestTemplate restTemplate) {
        super(baseUrl, restTemplate);
    }

    public List<RoleTO> children(Long roleId) {
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "role/children/{roleId}.json", RoleTO[].class, new Object[]{roleId}));
    }

    public int count() {
        return this.list().size();
    }

    public Response create(RoleTO roleTO) {
        RoleTO role = (RoleTO)this.getRestTemplate().postForObject(this.baseUrl + "role/create", (Object)roleTO, RoleTO.class, new Object[0]);
        URI location = URI.create(this.baseUrl + "role/read/" + role.getId() + ".json");
        return Response.created((URI)location).header("org.apache.syncope.resource.id", (Object)role.getId()).entity((Object)role).build();
    }

    public RoleTO delete(Long roleId) {
        return (RoleTO)this.getRestTemplate().getForObject(this.baseUrl + "role/delete/{roleId}", RoleTO.class, new Object[]{roleId});
    }

    public List<RoleTO> list() {
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "role/list.json", RoleTO[].class, new Object[0]));
    }

    public List<RoleTO> list(int page, int size) {
        throw new ServiceUnavailableException();
    }

    public RoleTO parent(Long roleId) {
        return (RoleTO)this.getRestTemplate().getForObject(this.baseUrl + "role/parent/{roleId}.json", RoleTO.class, new Object[]{roleId});
    }

    public RoleTO read(Long roleId) {
        return (RoleTO)this.getRestTemplate().getForObject(this.baseUrl + "role/read/{roleId}.json", RoleTO.class, new Object[]{roleId});
    }

    public List<RoleTO> search(NodeCond searchCondition) {
        return Arrays.asList((Object[])this.getRestTemplate().postForObject(this.baseUrl + "role/search", (Object)searchCondition, RoleTO[].class, new Object[0]));
    }

    public List<RoleTO> search(NodeCond searchCondition, int page, int size) {
        return Arrays.asList((Object[])this.getRestTemplate().postForObject(this.baseUrl + "role/search/{page}/{size}", (Object)searchCondition, RoleTO[].class, new Object[]{page, size}));
    }

    public int searchCount(NodeCond searchCondition) {
        return (Integer)this.getRestTemplate().postForObject(this.baseUrl + "role/search/count.json", (Object)searchCondition, Integer.class, new Object[0]);
    }

    public RoleTO selfRead(Long roleId) {
        return (RoleTO)this.getRestTemplate().getForObject(this.baseUrl + "role/selfRead/{roleId}", RoleTO.class, new Object[]{roleId});
    }

    public RoleTO update(Long roleId, RoleMod roleMod) {
        return (RoleTO)this.getRestTemplate().postForObject(this.baseUrl + "role/update", (Object)roleMod, RoleTO.class, new Object[0]);
    }
}

