/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.export.ActivitiListenerExport;
import org.activiti.bpmn.converter.export.LaneExport;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.Process;
import org.apache.commons.lang.StringUtils;

public class ProcessExport
implements BpmnXMLConstants {
    public static void writeProcess(Process process, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("process");
        xtw.writeAttribute("id", process.getId());
        if (StringUtils.isNotEmpty((String)process.getName())) {
            xtw.writeAttribute("name", process.getName());
        }
        xtw.writeAttribute("isExecutable", "true");
        if (process.getCandidateStarterUsers().size() > 0) {
            xtw.writeAttribute("activiti", "http://activiti.org/bpmn", "candidateStarterUsers", BpmnXMLUtil.convertToDelimitedString(process.getCandidateStarterUsers()));
        }
        if (process.getCandidateStarterGroups().size() > 0) {
            xtw.writeAttribute("activiti", "http://activiti.org/bpmn", "candidateStarterGroups", BpmnXMLUtil.convertToDelimitedString(process.getCandidateStarterGroups()));
        }
        if (StringUtils.isNotEmpty((String)process.getDocumentation())) {
            xtw.writeStartElement("documentation");
            xtw.writeCharacters(process.getDocumentation());
            xtw.writeEndElement();
        }
        LaneExport.writeLanes(process, xtw);
        boolean wroteListener = ActivitiListenerExport.writeListeners((BaseElement)process, false, xtw);
        if (wroteListener) {
            xtw.writeEndElement();
        }
    }
}

