/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.TimerEventDefinition;

public class TimerEventDefinitionParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "timerEventDefinition";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        if (!(parentElement instanceof Event)) {
            return;
        }
        TimerEventDefinition eventDefinition = new TimerEventDefinition();
        BpmnXMLUtil.addXMLLocation((BaseElement)eventDefinition, xtr);
        try {
            while (xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "timeDuration".equalsIgnoreCase(xtr.getLocalName())) {
                    eventDefinition.setTimeDuration(xtr.getElementText());
                } else if (xtr.isStartElement() && "timeDate".equalsIgnoreCase(xtr.getLocalName())) {
                    eventDefinition.setTimeDate(xtr.getElementText());
                } else if (xtr.isStartElement() && "timeCycle".equalsIgnoreCase(xtr.getLocalName())) {
                    eventDefinition.setTimeCycle(xtr.getElementText());
                } else if (!xtr.isEndElement() || !"timerEventDefinition".equalsIgnoreCase(xtr.getLocalName())) continue;
                break;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing timer event definition", (Throwable)e);
        }
        ((Event)parentElement).getEventDefinitions().add(eventDefinition);
    }
}

