/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.apache.commons.lang.StringUtils;

public class MessageEventDefinitionParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "messageEventDefinition";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        if (!(parentElement instanceof Event)) {
            return;
        }
        MessageEventDefinition eventDefinition = new MessageEventDefinition();
        BpmnXMLUtil.addXMLLocation((BaseElement)eventDefinition, xtr);
        eventDefinition.setMessageRef(xtr.getAttributeValue(null, "messageRef"));
        if (StringUtils.isEmpty((String)eventDefinition.getMessageRef())) {
            model.addProblem("attribute 'messageRef' is required", xtr);
        } else {
            int indexOfP = eventDefinition.getMessageRef().indexOf(58);
            if (indexOfP != -1) {
                String prefix = eventDefinition.getMessageRef().substring(0, indexOfP);
                String resolvedNamespace = model.getNamespace(prefix);
                eventDefinition.setMessageRef(resolvedNamespace + ":" + eventDefinition.getMessageRef().substring(indexOfP + 1));
            } else {
                eventDefinition.setMessageRef(model.getTargetNamespace() + ":" + eventDefinition.getMessageRef());
            }
            if (!model.containsMessageId(eventDefinition.getMessageRef())) {
                model.addProblem("Invalid 'messageRef': no message with id '" + eventDefinition.getMessageRef() + "' found.", xtr);
            }
        }
        ((Event)parentElement).getEventDefinitions().add(eventDefinition);
    }
}

