/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.XMLStreamReaderUtil;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.bpmn.model.alfresco.AlfrescoUserTask;
import org.apache.commons.lang.StringUtils;

public class UserTaskXMLConverter
extends BaseBpmnXMLConverter {
    List<String> formTypes = new ArrayList<String>();

    public UserTaskXMLConverter() {
        HumanPerformerParser humanPerformerParser = new HumanPerformerParser();
        this.childElementParsers.put(humanPerformerParser.getElementName(), humanPerformerParser);
        PotentialOwnerParser potentialOwnerParser = new PotentialOwnerParser();
        this.childElementParsers.put(potentialOwnerParser.getElementName(), potentialOwnerParser);
    }

    public static String getXMLType() {
        return "userTask";
    }

    public static Class<? extends BaseElement> getBpmnElementType() {
        return UserTask.class;
    }

    @Override
    protected String getXMLElementName() {
        return "userTask";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr) throws Exception {
        String expression;
        String formKey = xtr.getAttributeValue("http://activiti.org/bpmn", "formKey");
        UserTask userTask = null;
        if (StringUtils.isNotEmpty((String)formKey) && this.formTypes.contains(formKey)) {
            userTask = new AlfrescoUserTask();
        }
        if (userTask == null) {
            userTask = new UserTask();
        }
        BpmnXMLUtil.addXMLLocation(userTask, xtr);
        userTask.setDueDate(xtr.getAttributeValue("http://activiti.org/bpmn", "dueDate"));
        userTask.setFormKey(formKey);
        userTask.setAssignee(xtr.getAttributeValue("http://activiti.org/bpmn", "assignee"));
        userTask.setPriority(xtr.getAttributeValue("http://activiti.org/bpmn", "priority"));
        if (StringUtils.isNotEmpty((String)xtr.getAttributeValue("http://activiti.org/bpmn", "candidateUsers"))) {
            expression = xtr.getAttributeValue("http://activiti.org/bpmn", "candidateUsers");
            userTask.getCandidateUsers().addAll(this.parseDelimitedList(expression));
        }
        if (StringUtils.isNotEmpty((String)xtr.getAttributeValue("http://activiti.org/bpmn", "candidateGroups"))) {
            expression = xtr.getAttributeValue("http://activiti.org/bpmn", "candidateGroups");
            userTask.getCandidateGroups().addAll(this.parseDelimitedList(expression));
        }
        this.parseChildElements(this.getXMLElementName(), (BaseElement)userTask, xtr);
        return userTask;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, XMLStreamWriter xtw) throws Exception {
        UserTask userTask = (UserTask)element;
        this.writeQualifiedAttribute("assignee", userTask.getAssignee(), xtw);
        this.writeQualifiedAttribute("candidateUsers", this.convertToDelimitedString(userTask.getCandidateUsers()), xtw);
        this.writeQualifiedAttribute("candidateGroups", this.convertToDelimitedString(userTask.getCandidateGroups()), xtw);
        this.writeQualifiedAttribute("dueDate", userTask.getDueDate(), xtw);
        this.writeQualifiedAttribute("formKey", userTask.getFormKey(), xtw);
        if (userTask.getPriority() != null) {
            this.writeQualifiedAttribute("priority", userTask.getPriority().toString(), xtw);
        }
    }

    @Override
    protected void writeExtensionChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
        UserTask userTask = (UserTask)element;
        this.writeFormProperties((FlowElement)userTask, xtw);
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
    }

    public void addFormType(String formType) {
        if (StringUtils.isNotEmpty((String)formType)) {
            this.formTypes.add(formType);
        }
    }

    public class PotentialOwnerParser
    extends BaseChildElementParser {
        @Override
        public String getElementName() {
            return "potentialOwner";
        }

        @Override
        public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
            String expression;
            String resourceElement = XMLStreamReaderUtil.moveDown(xtr);
            if (StringUtils.isNotEmpty((String)resourceElement) && "resourceAssignmentExpression".equals(resourceElement) && StringUtils.isNotEmpty((String)(expression = XMLStreamReaderUtil.moveDown(xtr))) && "formalExpression".equals(expression)) {
                List<String> assignmentList = new ArrayList<String>();
                String assignmentText = xtr.getElementText();
                if (assignmentText.contains(",")) {
                    String[] assignmentArray = assignmentText.split(",");
                    assignmentList = Arrays.asList(assignmentArray);
                } else {
                    assignmentList.add(assignmentText);
                }
                for (String assignmentValue : assignmentList) {
                    if (assignmentValue == null || (assignmentValue = assignmentValue.trim()).length() == 0) continue;
                    String userPrefix = "user(";
                    String groupPrefix = "group(";
                    if (assignmentValue.startsWith(userPrefix)) {
                        assignmentValue = assignmentValue.substring(userPrefix.length(), assignmentValue.length() - 1).trim();
                        ((UserTask)parentElement).getCandidateUsers().add(assignmentValue);
                        continue;
                    }
                    if (assignmentValue.startsWith(groupPrefix)) {
                        assignmentValue = assignmentValue.substring(groupPrefix.length(), assignmentValue.length() - 1).trim();
                        ((UserTask)parentElement).getCandidateGroups().add(assignmentValue);
                        continue;
                    }
                    ((UserTask)parentElement).getCandidateGroups().add(assignmentValue);
                }
            }
        }
    }

    public class HumanPerformerParser
    extends BaseChildElementParser {
        @Override
        public String getElementName() {
            return "humanPerformer";
        }

        @Override
        public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
            String expression;
            String resourceElement;
            UserTask userTask = (UserTask)parentElement;
            if (StringUtils.isNotEmpty((String)userTask.getAssignee())) {
                model.addProblem("No duplicate assignee and humanPerformer definition allowed", xtr);
            }
            if (StringUtils.isNotEmpty((String)(resourceElement = XMLStreamReaderUtil.moveDown(xtr))) && "resourceAssignmentExpression".equals(resourceElement) && StringUtils.isNotEmpty((String)(expression = XMLStreamReaderUtil.moveDown(xtr))) && "formalExpression".equals(expression)) {
                ((UserTask)parentElement).setAssignee(xtr.getElementText());
            }
        }
    }
}

