/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.child.ScriptTextParser;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.ScriptTask;
import org.apache.commons.lang.StringUtils;

public class ScriptTaskXMLConverter
extends BaseBpmnXMLConverter {
    public ScriptTaskXMLConverter() {
        ScriptTextParser scriptTextParser = new ScriptTextParser();
        this.childElementParsers.put(scriptTextParser.getElementName(), scriptTextParser);
    }

    public static String getXMLType() {
        return "scriptTask";
    }

    public static Class<? extends BaseElement> getBpmnElementType() {
        return ScriptTask.class;
    }

    @Override
    protected String getXMLElementName() {
        return "scriptTask";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr) throws Exception {
        String autoStoreVariables;
        ScriptTask scriptTask = new ScriptTask();
        BpmnXMLUtil.addXMLLocation((BaseElement)scriptTask, xtr);
        scriptTask.setScriptFormat(xtr.getAttributeValue(null, "scriptFormat"));
        scriptTask.setResultVariable(xtr.getAttributeValue("http://activiti.org/bpmn", "resultVariable"));
        if (StringUtils.isEmpty((String)scriptTask.getResultVariable())) {
            scriptTask.setResultVariable(xtr.getAttributeValue("http://activiti.org/bpmn", "resultVariableName"));
        }
        if (StringUtils.isNotEmpty((String)(autoStoreVariables = xtr.getAttributeValue("http://activiti.org/bpmn", "autoStoreVariables")))) {
            scriptTask.setAutoStoreVariables(Boolean.valueOf(autoStoreVariables).booleanValue());
        }
        this.parseChildElements(this.getXMLElementName(), (BaseElement)scriptTask, xtr);
        return scriptTask;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, XMLStreamWriter xtw) throws Exception {
        ScriptTask scriptTask = (ScriptTask)element;
        this.writeDefaultAttribute("scriptFormat", scriptTask.getScriptFormat(), xtw);
        this.writeQualifiedAttribute("resultVariable", scriptTask.getResultVariable(), xtw);
        this.writeQualifiedAttribute("autoStoreVariables", String.valueOf(scriptTask.isAutoStoreVariables()), xtw);
    }

    @Override
    protected void writeExtensionChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
        ScriptTask scriptTask = (ScriptTask)element;
        if (StringUtils.isNotEmpty((String)scriptTask.getScript())) {
            xtw.writeStartElement("script");
            xtw.writeCharacters(scriptTask.getScript());
            xtw.writeEndElement();
        }
    }
}

