/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.types;

import java.text.ParseException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.apache.syncope.common.AbstractBaseBean;
import org.apache.syncope.common.types.AuditElements;
import org.apache.syncope.common.types.SyncopeLoggerType;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonTypeInfo;

@XmlType
@XmlRootElement
public class AuditLoggerName
extends AbstractBaseBean {
    private static final long serialVersionUID = -647989486671786839L;
    private final AuditElements.Category category;
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
    private final Enum<?> subcategory;
    private final AuditElements.Result result;

    @JsonCreator
    public AuditLoggerName(@JsonProperty(value="category") AuditElements.Category category, @JsonProperty(value="subcategory") Enum<?> subcategory, @JsonProperty(value="result") AuditElements.Result result) throws IllegalArgumentException {
        if (category == null || subcategory == null || result == null) {
            throw new IllegalArgumentException("Null values not permitted");
        }
        if (!category.getSubCategoryElements().contains(subcategory)) {
            throw new IllegalArgumentException(category.name() + " does not contain " + subcategory.name());
        }
        this.category = category;
        this.subcategory = subcategory;
        this.result = result;
    }

    public AuditElements.Category getCategory() {
        return this.category;
    }

    public AuditElements.Result getResult() {
        return this.result;
    }

    public Enum<?> getSubcategory() {
        return this.subcategory;
    }

    public String toLoggerName() {
        return SyncopeLoggerType.AUDIT.getPrefix() + '.' + this.category.name() + '.' + this.subcategory.name() + '.' + this.result.name();
    }

    public static AuditLoggerName fromLoggerName(String loggerName) throws IllegalArgumentException, ParseException {
        if (StringUtils.isBlank((String)loggerName)) {
            throw new IllegalArgumentException("Null value not permitted");
        }
        if (!loggerName.startsWith(SyncopeLoggerType.AUDIT.getPrefix())) {
            throw new ParseException("Audit logger name must start with " + SyncopeLoggerType.AUDIT.getPrefix(), 0);
        }
        String[] splitted = loggerName.split("\\.");
        if (splitted == null || splitted.length < 5) {
            throw new ParseException("Unparsable logger name", 0);
        }
        AuditElements.Category category = AuditElements.Category.valueOf(splitted[2]);
        Enum subcategory = Enum.valueOf(category.getSubCategory(), splitted[3]);
        AuditElements.Result result = AuditElements.Result.valueOf(splitted[4]);
        return new AuditLoggerName(category, subcategory, result);
    }
}

