/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class PCLRenderingMode
implements Serializable {
    private static final long serialVersionUID = 6359884255324755026L;
    public static final PCLRenderingMode QUALITY = new PCLRenderingMode("quality", 1.0f);
    public static final PCLRenderingMode SPEED = new PCLRenderingMode("speed", 0.25f);
    public static final PCLRenderingMode BITMAP = new PCLRenderingMode("bitmap", 1.0f);
    private String name;
    private float defaultDitheringQuality;

    private PCLRenderingMode(String name, float defaultDitheringQuality) {
        this.name = name;
        this.defaultDitheringQuality = defaultDitheringQuality;
    }

    public String getName() {
        return this.name;
    }

    public float getDefaultDitheringQuality() {
        return this.defaultDitheringQuality;
    }

    public static PCLRenderingMode valueOf(String name) {
        if (QUALITY.getName().equalsIgnoreCase(name)) {
            return QUALITY;
        }
        if (SPEED.getName().equalsIgnoreCase(name)) {
            return SPEED;
        }
        if (BITMAP.getName().equalsIgnoreCase(name)) {
            return BITMAP;
        }
        throw new IllegalArgumentException("Illegal value for enumeration: " + name);
    }

    private Object readResolve() throws ObjectStreamException {
        return PCLRenderingMode.valueOf(this.getName());
    }

    public String toString() {
        return "PCLRenderingMode:" + this.name;
    }
}

