/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CorrespondingPropertyMaker;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;

public class DimensionPropertyMaker
extends CorrespondingPropertyMaker {
    private int[][] extraCorresponding = null;

    public DimensionPropertyMaker(PropertyMaker baseMaker) {
        super(baseMaker);
    }

    public void setExtraCorresponding(int[][] extraCorresponding) {
        if (extraCorresponding == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < extraCorresponding.length; ++i) {
            int[] eca = extraCorresponding[i];
            if (eca != null && eca.length == 4) continue;
            throw new IllegalArgumentException("bad sub-array @ [" + i + "]");
        }
        this.extraCorresponding = extraCorresponding;
    }

    public boolean isCorrespondingForced(PropertyList propertyList) {
        if (super.isCorrespondingForced(propertyList)) {
            return true;
        }
        for (int i = 0; i < this.extraCorresponding.length; ++i) {
            int wmcorr = this.extraCorresponding[i][0];
            if (propertyList.getExplicit(wmcorr) == null) continue;
            return true;
        }
        return false;
    }

    public Property compute(PropertyList propertyList) throws PropertyException {
        int wmcorr;
        Property subprop;
        Property p = super.compute(propertyList);
        if (p == null) {
            p = this.baseMaker.make(propertyList);
        }
        if ((subprop = propertyList.getExplicitOrShorthand(wmcorr = propertyList.selectFromWritingMode(this.extraCorresponding[0][0], this.extraCorresponding[0][1], this.extraCorresponding[0][2], this.extraCorresponding[0][3]))) != null) {
            this.baseMaker.setSubprop(p, 3072, subprop);
        }
        if ((subprop = propertyList.getExplicitOrShorthand(wmcorr = propertyList.selectFromWritingMode(this.extraCorresponding[1][0], this.extraCorresponding[1][1], this.extraCorresponding[1][2], this.extraCorresponding[1][3]))) != null) {
            this.baseMaker.setSubprop(p, 2560, subprop);
        }
        return p;
    }
}

