/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.DestinationRegistryImpl;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitConfigurer;
import org.apache.cxf.transport.http.HTTPConduitFactory;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.cxf.transport.http.URLConnectionHTTPConduit;
import org.apache.cxf.transport.servlet.ServletDestinationFactory;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.http.AddressType;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;

@NoJSR250Annotations(unlessNull={"bus"})
public class HTTPTransportFactory
extends AbstractTransportFactory
implements WSDLEndpointFactory,
ConduitInitiator,
DestinationFactory {
    public static final List<String> DEFAULT_NAMESPACES = Arrays.asList("http://cxf.apache.org/transports/http", "http://cxf.apache.org/transports/http/configuration", "http://schemas.xmlsoap.org/wsdl/http", "http://schemas.xmlsoap.org/wsdl/http/");
    private static final Logger LOG = LogUtils.getL7dLogger(HTTPTransportFactory.class);
    private static final Set<String> URI_PREFIXES = new HashSet<String>();
    protected final DestinationRegistry registry;

    public HTTPTransportFactory() {
        this(new DestinationRegistryImpl());
    }

    public HTTPTransportFactory(Bus b) {
        this(b, null);
    }

    public HTTPTransportFactory(Bus b, DestinationRegistry registry) {
        super(DEFAULT_NAMESPACES, null);
        if (registry == null && b != null) {
            registry = (DestinationRegistry)b.getExtension(DestinationRegistry.class);
        }
        if (registry == null) {
            registry = new DestinationRegistryImpl();
        }
        this.registry = registry;
        this.bus = b;
        this.register();
    }

    public HTTPTransportFactory(DestinationRegistry registry) {
        super(DEFAULT_NAMESPACES);
        this.registry = registry;
    }

    @Resource
    public void setBus(Bus b) {
        super.setBus(b);
    }

    public DestinationRegistry getRegistry() {
        return this.registry;
    }

    public void setActivationNamespaces(Collection<String> ans) {
        this.setTransportIds(new ArrayList<String>(ans));
    }

    public EndpointInfo createEndpointInfo(ServiceInfo serviceInfo, BindingInfo b, List<?> ees) {
        if (ees != null) {
            for (Object extensor : ees) {
                if (extensor instanceof HTTPAddress) {
                    HTTPAddress httpAdd = (HTTPAddress)extensor;
                    HttpEndpointInfo info = new HttpEndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
                    info.setAddress(httpAdd.getLocationURI());
                    info.addExtensor(httpAdd);
                    return info;
                }
                if (!(extensor instanceof AddressType)) continue;
                AddressType httpAdd = (AddressType)extensor;
                HttpEndpointInfo info = new HttpEndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
                info.setAddress(httpAdd.getLocation());
                info.addExtensor(httpAdd);
                return info;
            }
        }
        HttpEndpointInfo hei = new HttpEndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
        HttpAddressType at = new HttpAddressType();
        hei.addExtensor((Object)at);
        return hei;
    }

    public void createPortExtensors(EndpointInfo ei, Service service) {
    }

    public Set<String> getUriPrefixes() {
        return URI_PREFIXES;
    }

    protected void configure(Object bean) {
        this.configure(bean, null, null);
    }

    protected void configure(Object bean, String name, String extraName) {
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(name, bean);
            if (extraName != null) {
                configurer.configureBean(extraName, bean);
            }
        }
    }

    public Conduit getConduit(EndpointInfo endpointInfo) throws IOException {
        return this.getConduit(endpointInfo, endpointInfo.getTarget());
    }

    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target) throws IOException {
        HTTPConduitConfigurer c1;
        String address;
        HTTPConduitFactory factory = this.findFactory(endpointInfo);
        HTTPConduit conduit = null;
        if (factory != null) {
            conduit = factory.createConduit(this, endpointInfo, target);
        }
        if (conduit == null) {
            conduit = new URLConnectionHTTPConduit(this.bus, endpointInfo, target);
        }
        if ((address = conduit.getAddress()) != null && address.indexOf(63) != -1) {
            address = address.substring(0, address.indexOf(63));
        }
        if ((c1 = (HTTPConduitConfigurer)this.bus.getExtension(HTTPConduitConfigurer.class)) != null) {
            c1.configure(conduit.getBeanName(), address, conduit);
        }
        this.configure(conduit, conduit.getBeanName(), address);
        conduit.finalizeConfig();
        return conduit;
    }

    protected HTTPConduitFactory findFactory(EndpointInfo endpointInfo) {
        HTTPConduitFactory f = (HTTPConduitFactory)endpointInfo.getProperty(HTTPConduitFactory.class.getName(), HTTPConduitFactory.class);
        if (f == null) {
            f = (HTTPConduitFactory)this.bus.getExtension(HTTPConduitFactory.class);
        }
        return f;
    }

    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        if (endpointInfo == null) {
            throw new IllegalArgumentException("EndpointInfo cannot be null");
        }
        AbstractHTTPDestination d = this.registry.getDestinationForPath(endpointInfo.getAddress());
        if (d == null) {
            HttpDestinationFactory jettyFactory = (HttpDestinationFactory)this.bus.getExtension(HttpDestinationFactory.class);
            String addr = endpointInfo.getAddress();
            if (jettyFactory == null && addr != null && addr.startsWith("http")) {
                String m = new Message("NO_HTTP_DESTINATION_FACTORY_FOUND", LOG, new Object[0]).toString();
                LOG.log(Level.SEVERE, m);
                throw new IOException(m);
            }
            HttpDestinationFactory factory = null;
            factory = jettyFactory != null && (addr == null || addr.startsWith("http")) ? jettyFactory : new ServletDestinationFactory();
            d = factory.createDestination(endpointInfo, this.getBus(), this.registry);
            this.registry.addDestination(d);
            this.configure((Object)d);
            d.finalizeConfig();
        }
        return d;
    }

    static {
        URI_PREFIXES.add("http://");
        URI_PREFIXES.add("https://");
    }

    private static class HttpAddressType
    extends AddressType
    implements HTTPAddress,
    SOAPAddress {
        private static final long serialVersionUID = 7048265985129995746L;

        public HttpAddressType() {
            this.setElementType(new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address"));
        }

        public String getLocationURI() {
            return this.getLocation();
        }

        public void setLocationURI(String locationURI) {
            this.setLocation(locationURI);
        }
    }

    private static class HttpEndpointInfo
    extends EndpointInfo {
        AddressType saddress;

        HttpEndpointInfo(ServiceInfo serv, String trans) {
            super(serv, trans);
        }

        public void setAddress(String s) {
            super.setAddress(s);
            if (this.saddress != null) {
                this.saddress.setLocation(s);
            }
        }

        public void addExtensor(Object el) {
            super.addExtensor(el);
            if (el instanceof AddressType) {
                this.saddress = (AddressType)el;
            }
        }
    }
}

