/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.actuate;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.apache.syncope.common.lib.AMSession;
import org.apache.syncope.sra.security.cas.CASAuthenticationToken;
import org.apache.syncope.sra.security.saml2.SAML2AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.session.MapSession;

@Endpoint(id="sraSessions")
public class SRASessions {
    protected static final Logger LOG = LoggerFactory.getLogger(SRASessions.class);
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected final CacheManager cacheManager;

    public SRASessions(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected static AMSession map(MapSession mapSession) {
        String principal;
        SecurityContext ctx = (SecurityContext)mapSession.getAttribute("SPRING_SECURITY_CONTEXT");
        if (ctx == null) {
            return null;
        }
        AMSession session = new AMSession();
        session.setKey(mapSession.getId());
        session.setAuthenticationDate(mapSession.getCreationTime().atOffset(OffsetDateTime.now().getOffset()));
        Authentication authentication = ctx.getAuthentication();
        if (authentication instanceof SAML2AuthenticationToken) {
            SAML2AuthenticationToken saml2AuthenticationToken = (SAML2AuthenticationToken)authentication;
            principal = saml2AuthenticationToken.getPrincipal().getUserProfile().getUsername();
        } else {
            authentication = ctx.getAuthentication();
            if (authentication instanceof CASAuthenticationToken) {
                CASAuthenticationToken casAuthenticationToken = (CASAuthenticationToken)authentication;
                principal = casAuthenticationToken.getPrincipal().getPrincipal().getName();
            } else {
                authentication = ctx.getAuthentication();
                if (authentication instanceof OAuth2AuthenticationToken) {
                    OAuth2AuthenticationToken oauth2AuthenticationToken = (OAuth2AuthenticationToken)authentication;
                    principal = oauth2AuthenticationToken.getPrincipal().getName();
                } else {
                    principal = ctx.getAuthentication().getPrincipal().toString();
                }
            }
        }
        session.setPrincipal(principal);
        try {
            session.setJson(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)ctx.getAuthentication()));
        }
        catch (JsonProcessingException e) {
            LOG.error("While serializing session {}", (Object)mapSession.getId(), (Object)e);
        }
        return session;
    }

    @ReadOperation
    public List<AMSession> list() {
        return ((ConcurrentMap)this.cacheManager.getCache("default").getNativeCache()).values().stream().map(MapSession.class::cast).map(SRASessions::map).filter(Objects::nonNull).toList();
    }

    @ReadOperation
    public AMSession read(@Selector String id) {
        Object object;
        Cache.ValueWrapper value = this.cacheManager.getCache("default").get((Object)id);
        if (value == null || !((object = value.get()) instanceof MapSession)) {
            return null;
        }
        MapSession mapSession = (MapSession)object;
        return SRASessions.map(mapSession);
    }

    @DeleteOperation
    public void delete(@Selector String id) {
        this.cacheManager.getCache("default").evict((Object)id);
    }
}

